package cn.sinozg.applet.common.config;


import cn.sinozg.applet.common.handler.TenantHandler;
import cn.sinozg.applet.common.properties.AppValue;
import cn.sinozg.applet.common.utils.SnowFlake;
import com.baomidou.mybatisplus.annotation.DbType;
import com.baomidou.mybatisplus.core.incrementer.IdentifierGenerator;
import com.baomidou.mybatisplus.extension.plugins.MybatisPlusInterceptor;
import com.baomidou.mybatisplus.extension.plugins.inner.BlockAttackInnerInterceptor;
import com.baomidou.mybatisplus.extension.plugins.inner.PaginationInnerInterceptor;
import com.baomidou.mybatisplus.extension.plugins.inner.TenantLineInnerInterceptor;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

import jakarta.annotation.Resource;

/**
* Mybatis 配置
* @Author: xyb
* @Description:
* @Date: 2022-11-14 下午 10:09
**/
@Configuration
public class MybatisPlusConfig {

    @Resource
    private AppValue app;

    /**
     * mybatis plus 插件
     * @return 插件
     */
    @Bean
    public MybatisPlusInterceptor paginationInterceptor() {
        MybatisPlusInterceptor interceptor = new MybatisPlusInterceptor();
        interceptor.addInnerInterceptor(new PaginationInnerInterceptor(DbType.MYSQL));
        // 多租户
        if (app.getTenant().isEnable()) {
            // 多租户
            TenantLineInnerInterceptor tenantInner = new TenantLineInnerInterceptor(new TenantHandler());
            interceptor.addInnerInterceptor(tenantInner);
        }
        // 防止全部更新和删除
        interceptor.addInnerInterceptor(new BlockAttackInnerInterceptor());
        return interceptor;
    }

    /**
     * 主键生成策略
     * @return 主键
     */
    @Bean
    public IdentifierGenerator idGen(){
        return e -> SnowFlake.geneId();
    }
}