package cn.sinozg.applet.common.filter;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import jakarta.servlet.ReadListener;
import jakarta.servlet.ServletInputStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;

/**
 * 请求 参数缓存 包装 类
 * @Author: xyb
 * @Description:
 * @Date: 2023-03-10 下午 11:52
 **/
public class WrapperInputStream extends ServletInputStream {

    private final InputStream cacheInputStream;

    private final Logger log = LoggerFactory.getLogger(WrapperInputStream.class);

    public WrapperInputStream(byte[] body){
        this.cacheInputStream = new ByteArrayInputStream(body);
    }

    @Override
    public boolean isFinished() {
        try {
            return cacheInputStream.available() == 0;
        } catch (Exception e) {
            log.error("缓存请求参数流 异常，{}", e.getMessage());
        }
        return false;
    }

    @Override
    public boolean isReady() {
        return true;
    }

    @Override
    public void setReadListener(ReadListener readListener) {

    }

    @Override
    public int read() throws IOException {
        return cacheInputStream.read();
    }
}