/*
 * Decompiled with CFR 0.152.
 */
package cn.sinozg.applet.biz.system.service.impl;

import cn.sinozg.applet.biz.system.service.FrameworkLoginLogService;
import cn.sinozg.applet.biz.system.service.UserLoginOutService;
import cn.sinozg.applet.biz.system.vo.response.LoginAgentResponse;
import cn.sinozg.applet.common.service.FrameworkAuthService;
import cn.sinozg.applet.common.utils.RedisUtil;
import jakarta.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;

@Service
public class UserLoginOutServiceImpl
implements UserLoginOutService {
    @Resource
    private FrameworkLoginLogService frameworkLoginLogService;
    @Resource
    private FrameworkAuthService frameworkAuthService;

    @Override
    public void logout(String tokenId, String userId) {
        String message;
        boolean force = false;
        if (StringUtils.isAllBlank((CharSequence[])new CharSequence[]{tokenId, userId})) {
            message = "\u672c\u4eba\u767b\u51fa\uff01";
            tokenId = this.frameworkAuthService.tokenWithException();
        } else {
            force = true;
            message = "\u5f3a\u5236\u8e22\u6389\uff01";
        }
        if (StringUtils.isNotBlank((CharSequence)tokenId)) {
            userId = this.frameworkAuthService.loginIdByToken(tokenId);
        } else {
            tokenId = this.frameworkAuthService.tokenById(userId);
        }
        if (StringUtils.isAnyEmpty((CharSequence[])new CharSequence[]{userId, tokenId})) {
            return;
        }
        LoginAgentResponse agent = this.frameworkLoginLogService.browserInfo();
        this.frameworkLoginLogService.insertLoginInfo(agent, userId, null, "01", true, message);
        RedisUtil.deleteObject((String)String.format("jby:biz:user_info:%s:%s", tokenId, userId));
        if (force) {
            this.frameworkAuthService.kickOutByTokenValue(tokenId);
        } else {
            this.frameworkAuthService.logout(tokenId);
        }
    }
}

