/*
 * Decompiled with CFR 0.152.
 */
package cn.sinozg.applet.common.filter;

import cn.sinozg.applet.common.core.model.AesRsaDecrypt;
import cn.sinozg.applet.common.filter.WrapperInputStream;
import cn.sinozg.applet.common.properties.SignValue;
import cn.sinozg.applet.common.utils.CypherUtil;
import cn.sinozg.applet.common.utils.JsonUtil;
import cn.sinozg.applet.common.utils.WebUtil;
import jakarta.servlet.ServletInputStream;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletRequestWrapper;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WrapperRequest
extends HttpServletRequestWrapper {
    private final byte[] body;
    private final SignValue sign;
    private final Logger log = LoggerFactory.getLogger(WrapperRequest.class);
    private final Map<String, String> headerMap = new HashMap<String, String>();

    public WrapperRequest(HttpServletRequest request, ServletResponse response, SignValue sign) throws IOException {
        super(request);
        this.sign = sign;
        request.setCharacterEncoding("UTF-8");
        response.setCharacterEncoding("UTF-8");
        this.body = this.decrypt();
    }

    public BufferedReader getReader() throws IOException {
        return new BufferedReader(new InputStreamReader((InputStream)this.getInputStream()));
    }

    public ServletInputStream getInputStream() {
        return new WrapperInputStream(this.body);
    }

    public String getHeader(String name) {
        String value = super.getHeader(name);
        if (this.headerMap.containsKey(name)) {
            value = this.headerMap.get(name);
        }
        return value;
    }

    public Enumeration<String> getHeaderNames() {
        ArrayList names = Collections.list(super.getHeaderNames());
        names.addAll(this.headerMap.keySet());
        return Collections.enumeration(names);
    }

    public Enumeration<String> getHeaders(String name) {
        ArrayList values = Collections.list(super.getHeaders(name));
        if (this.headerMap.containsKey(name)) {
            values.add(this.headerMap.get(name));
        }
        return Collections.enumeration(values);
    }

    private byte[] decrypt() throws IOException {
        String jsonBody = WebUtil.getBodyString((ServletRequest)this.getRequest());
        byte[] bytes = null;
        if (this.sign.isRsaEnable()) {
            AesRsaDecrypt decrypt = (AesRsaDecrypt)JsonUtil.toPojo((String)jsonBody, AesRsaDecrypt.class);
            if (decrypt == null) {
                throw new IOException("Encryption parameter format error!");
            }
            this.headerMap.put("Whj-Pub-Key", decrypt.getPublicKey());
            try {
                bytes = CypherUtil.decryptJson((String)decrypt.getData(), (String)this.sign.getPrivateKey(), (String)decrypt.getAesKey());
            }
            catch (Exception e) {
                this.log.error("\u89e3\u5bc6\u53c2\u6570\u9519\u8bef\uff01", (Throwable)e);
            }
            if (bytes == null) {
                throw new IOException("Decryption parameter error!");
            }
        } else {
            bytes = jsonBody.getBytes(StandardCharsets.UTF_8);
        }
        return bytes;
    }
}

