/*
 * Decompiled with CFR 0.152.
 */
package cn.sinozg.applet.common.handler;

import cn.sinozg.applet.common.core.base.BaseResponse;
import cn.sinozg.applet.common.exception.CavException;
import cn.sinozg.applet.common.utils.MsgUtil;
import cn.sinozg.applet.common.utils.VerifyUtil;
import jakarta.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.MethodArgumentNotValidException;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestControllerAdvice;

@RestControllerAdvice
public class GlobalExceptionHandler {
    private static final Logger log = LoggerFactory.getLogger(GlobalExceptionHandler.class);

    @ResponseBody
    @ExceptionHandler(value={Exception.class})
    public BaseResponse<String> jsonHandler(HttpServletRequest request, Exception e) {
        log.error("GlobalExceptionHandler.jsonHandler start");
        return MsgUtil.error((HttpServletRequest)request, (Exception)e, (String)"BIZ000100015", (Object[])new Object[0]);
    }

    @ResponseBody
    @ExceptionHandler(value={CavException.class})
    public BaseResponse<String> cavException(HttpServletRequest request, CavException e) {
        log.error("business exception start");
        return MsgUtil.error((HttpServletRequest)request, (Exception)e, (String)e.getCode(), (Object[])e.getParameters());
    }

    @ResponseBody
    @ExceptionHandler(value={MethodArgumentNotValidException.class})
    public BaseResponse<String> argumentNotValidException(HttpServletRequest request, MethodArgumentNotValidException e) {
        log.error("MethodArgumentNotValidException start");
        String msg = VerifyUtil.errorInfo((BindingResult)e.getBindingResult());
        return MsgUtil.error((HttpServletRequest)request, (Exception)e, (String)"BIZ000100014", (Object[])new Object[]{msg});
    }
}

