package cn.sinozg.applet.biz.system.entity;

import cn.sinozg.applet.common.core.base.BaseEntity;
import cn.sinozg.applet.common.core.model.I18nName;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.baomidou.mybatisplus.extension.handlers.JacksonTypeHandler;
import io.swagger.v3.oas.annotations.media.Schema;
import java.io.Serial;

/**
* 字典数据表表
* @Description
* @Copyright Copyright (c) 2022
* @Author: xyb
* @since 2022-09-16 12:02:41
*/
@TableName("sys_dict_data")
@Schema(name = "DictData", description = "字典数据表")
public class DictData extends BaseEntity {

    @Serial
    private static final long serialVersionUID = 1L;

    /** 字典编码id */
    @Schema(description = "字典编码id")
    @TableId(value = "id", type = IdType.ASSIGN_ID)
    private String id;

    /** 字典排序 */
    @Schema(description = "字典排序")
    @TableField("dict_sort")
    private Integer dictSort;

    /** 字典标签 */
    @Schema(description = "字典标签")
    @TableField("dict_label")
    private String dictLabel;

    /** 编码名称 */
    @Schema(description = "编码名称")
    @TableField(value = "dict_json_label", typeHandler = JacksonTypeHandler.class)
    private I18nName i18nLabel;

    /** 字典键值 */
    @Schema(description = "字典键值")
    @TableField("dict_value")
    private String dictValue;

    /** 父值 */
    @Schema(description = "父值")
    @TableField("pater_value")
    private String paterValue;

    /** 字典类型 */
    @Schema(description = "字典类型")
    @TableField("dict_type")
    private String dictType;

    /** 样式属性（其他样式扩展） */
    @Schema(description = "样式属性（其他样式扩展）")
    @TableField("css_class")
    private String cssClass;

    /** 表格回显样式 */
    @Schema(description = "表格回显样式")
    @TableField("list_class")
    private String listClass;

    /** 是否默认;Y是 N否 */
    @Schema(description = "是否默认;Y是 N否")
    @TableField("dict_default")
    private String dictDefault;

    /** 状态;00正常 01停用 */
    @Schema(description = "状态;00正常 01停用")
    @TableField("data_status")
    private String dataStatus;

    /**
     * 获取 字典编码id
     *
     * @return id 字典编码id
     */
    public String getId() {
        return this.id;
    }

    /**
     * 设置 字典编码id
     *
     * @param id 字典编码id
     */
    public void setId(String id) {
        this.id = id;
    }

    /**
     * 获取 字典排序
     *
     * @return dictSort 字典排序
     */
    public Integer getDictSort() {
        return this.dictSort;
    }

    /**
     * 设置 字典排序
     *
     * @param dictSort 字典排序
     */
    public void setDictSort(Integer dictSort) {
        this.dictSort = dictSort;
    }

    /**
     * 获取 字典标签
     *
     * @return dictLabel 字典标签
     */
    public String getDictLabel() {
        return this.dictLabel;
    }

    /**
     * 设置 字典标签
     *
     * @param dictLabel 字典标签
     */
    public void setDictLabel(String dictLabel) {
        this.dictLabel = dictLabel;
    }

    /**
     * 获取 编码名称
     *
     * @return i18nLabel 编码名称
     */
    public I18nName getI18nLabel() {
        return this.i18nLabel;
    }

    /**
     * 设置 编码名称
     *
     * @param i18nLabel 编码名称
     */
    public void setI18nLabel(I18nName i18nLabel) {
        this.i18nLabel = i18nLabel;
    }

    /**
     * 获取 字典键值
     *
     * @return dictValue 字典键值
     */
    public String getDictValue() {
        return this.dictValue;
    }

    /**
     * 设置 字典键值
     *
     * @param dictValue 字典键值
     */
    public void setDictValue(String dictValue) {
        this.dictValue = dictValue;
    }

    /**
     * 获取 父值
     *
     * @return paterValue 父值
     */
    public String getPaterValue() {
        return this.paterValue;
    }

    /**
     * 设置 父值
     *
     * @param paterValue 父值
     */
    public void setPaterValue(String paterValue) {
        this.paterValue = paterValue;
    }

    /**
     * 获取 字典类型
     *
     * @return dictType 字典类型
     */
    public String getDictType() {
        return this.dictType;
    }

    /**
     * 设置 字典类型
     *
     * @param dictType 字典类型
     */
    public void setDictType(String dictType) {
        this.dictType = dictType;
    }

    /**
     * 获取 样式属性（其他样式扩展）
     *
     * @return cssClass 样式属性（其他样式扩展）
     */
    public String getCssClass() {
        return this.cssClass;
    }

    /**
     * 设置 样式属性（其他样式扩展）
     *
     * @param cssClass 样式属性（其他样式扩展）
     */
    public void setCssClass(String cssClass) {
        this.cssClass = cssClass;
    }

    /**
     * 获取 表格回显样式
     *
     * @return listClass 表格回显样式
     */
    public String getListClass() {
        return this.listClass;
    }

    /**
     * 设置 表格回显样式
     *
     * @param listClass 表格回显样式
     */
    public void setListClass(String listClass) {
        this.listClass = listClass;
    }

    /**
     * 获取 是否默认;Y是 N否
     *
     * @return dictDefault 是否默认;Y是 N否
     */
    public String getDictDefault() {
        return this.dictDefault;
    }

    /**
     * 设置 是否默认;Y是 N否
     *
     * @param dictDefault 是否默认;Y是 N否
     */
    public void setDictDefault(String dictDefault) {
        this.dictDefault = dictDefault;
    }

    /**
     * 获取 状态;00正常 01停用
     *
     * @return dataStatus 状态;00正常 01停用
     */
    public String getDataStatus() {
        return this.dataStatus;
    }

    /**
     * 设置 状态;00正常 01停用
     *
     * @param dataStatus 状态;00正常 01停用
     */
    public void setDataStatus(String dataStatus) {
        this.dataStatus = dataStatus;
    }
}
