package cn.sinozg.applet.biz.system.service;

import cn.sinozg.applet.biz.system.entity.LoginInfo;
import cn.sinozg.applet.biz.system.vo.request.LoginInfoPageListRequest;
import cn.sinozg.applet.biz.system.vo.response.LoginInfoPageListResponse;
import cn.sinozg.applet.common.core.base.BasePageResponse;
import cn.sinozg.applet.common.core.base.PagingRequest;
import com.baomidou.mybatisplus.extension.service.IService;

import java.util.List;

/**
 * 系统访问记录 服务类
 *
 * @Author: xyb
 * @Description
 * @Copyright Copyright (c) 2022
 * @since 2022-09-14 12:51:35
 */
public interface LoginInfoService extends IService<LoginInfo> {

    /**
     * 查询系统登录日志集合
     * @param page 分页对象
     * @param loginInfo 访问日志对象
     * @return 登录记录集合
     */
    BasePageResponse<List<LoginInfoPageListResponse>> selectLoginInfoPage(PagingRequest page, LoginInfoPageListRequest loginInfo);

    /**
     * 查询系统登录日志集合
     * @param loginInfo 查询参数
     * @return 集合
     */
    List<LoginInfoPageListResponse> list(LoginInfoPageListRequest loginInfo);

    /**
     * 批量删除系统登录日志
     *
     * @param infoIds 需要删除的登录日志ID
     * @return 成功条数
     */
    int deleteLoginInfoByIds(List<String> infoIds);

    /**
     * 清空系统登录日志
     */
    void cleanLoginInfo();
}
