package cn.sinozg.applet.biz.system.service.impl;

import cn.sinozg.applet.biz.system.entity.DictData;
import cn.sinozg.applet.biz.system.mapper.DictDataMapper;
import cn.sinozg.applet.biz.system.service.DictDataService;
import cn.sinozg.applet.biz.system.vo.request.DictDataPageRequest;
import cn.sinozg.applet.biz.system.vo.response.DictListResponse;
import cn.sinozg.applet.common.core.base.BaseResponse;
import cn.sinozg.applet.common.core.base.PagingRequest;
import cn.sinozg.applet.common.core.model.DictDataVo;
import cn.sinozg.applet.common.enums.DictType;
import cn.sinozg.applet.common.utils.DictUtil;
import cn.sinozg.applet.common.utils.PageUtil;
import cn.sinozg.applet.common.utils.PojoUtil;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import jakarta.annotation.Resource;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.stereotype.Service;

/**
 * 字典数据表 服务实现类
 *
 * @Author: xyb
 * @Description
 * @Copyright Copyright (c) 2022
 * @since 2022-09-14 12:51:35
 */
@Service
public class DictDataServiceImpl extends ServiceImpl<DictDataMapper, DictData> implements DictDataService {

    @Resource
    private DictDataMapper dictDataMapper;

    @Override
    public Map<String, List<DictDataVo>> allDictCache() {
        List<DictDataVo> list = dictDataMapper.dictCache();
        Map<String, List<DictDataVo>> map = PojoUtil.groupMap(list, DictDataVo::getDictType);
        map.forEach((k, v) -> v.sort(Comparator.comparing(DictDataVo::getDictSort)));
        return map;
    }

    @Override
    public List<DictListResponse> dictList(String type) {
        List<DictDataVo> list = DictUtil.getDictCache(DictType.byCode(type));
        if (CollectionUtils.isNotEmpty(list)) {
            list.sort(Comparator.comparing(DictDataVo::getDictSort));
        }
        return PojoUtil.toList(list, d -> new DictListResponse(d.getDictValue(), DictUtil.dictLabel(d, null)));
    }

    @Override
    public Map<String, List<DictListResponse>> dictLists(List<String> type) {
        Map<String, List<DictListResponse>> map = new HashMap<>();
        type.forEach(k -> map.put(k, dictList(k)));
        return map;
    }

    @Override
    public BaseResponse<List<DictData>> dictDataPage(PagingRequest page, DictDataPageRequest request) {
        PageUtil<DictData, DictDataPageRequest> pu = (p, q) -> dictDataMapper.pageDictData(p, q);
        return pu.page(page, request);
    }
}
