package cn.sinozg.applet.common.config;

import cn.sinozg.applet.common.filter.WrapperFilter;
import cn.sinozg.applet.common.interceptor.ParamsInterceptor;
import cn.sinozg.applet.common.properties.ApiUrlValue;
import cn.sinozg.applet.common.properties.AppValue;
import cn.sinozg.applet.common.service.CipherService;
import cn.sinozg.applet.common.service.FrameworkAuthService;
import cn.sinozg.applet.common.service.FrameworkInitDataService;
import cn.sinozg.applet.common.service.FrameworkTenantService;
import jakarta.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.web.servlet.FilterRegistrationBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.config.annotation.InterceptorRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;

/**
* 鉴权 全局拦截器
* @Author: xyb
* @Description:
* @Date: 2022-11-14 下午 10:09
**/
@Configuration
public class SystemWebConfig implements WebMvcConfigurer {

    @Resource
    private AppValue app;

    @Resource
    private CipherService cipherService;

    @Resource
    private ParamsInterceptor paramsInterceptor;

    @Resource
    private FrameworkInitDataService initDataService;

    @Resource
    private FrameworkAuthService authService;

    @Resource
    private FrameworkTenantService tenantService;

    private final Logger log = LoggerFactory.getLogger(SystemWebConfig.class);

    @Override
    public void addInterceptors(@NotNull InterceptorRegistry registry) {
        log.info("addInterceptors");
        ApiUrlValue apiUrl = app.getApiUrl();
        // 参数校验
        if (CollectionUtils.isNotEmpty(apiUrl.getParamsPatterns())) {
            registry.addInterceptor(paramsInterceptor).addPathPatterns(apiUrl.getParamsPatterns());
        }
        // token 拦截
        HandlerInterceptor authInterceptor = authService.authInterceptor();
        if (authInterceptor != null) {
            registry.addInterceptor(authInterceptor)
                    .addPathPatterns(apiUrl.getAuthPatterns())
                    .excludePathPatterns(apiUrl.getAuthExcludePath());
        }
        tenantService.expiredCheckInterceptor(registry);
        initDataService.addCustomInterceptor(registry);
    }

    /**
     * http请求 包装
     * @return 过滤器
     */
    @Bean
    public FilterRegistrationBean<WrapperFilter> registrationBean (){
        ApiUrlValue apiUrl = app.getApiUrl();
        FilterRegistrationBean<WrapperFilter> bean = new FilterRegistrationBean<>();
        bean.setFilter(new WrapperFilter(app, cipherService));
        bean.addUrlPatterns(apiUrl.getWrapperUrl());
        return bean;
    }
}
