package cn.sinozg.applet.common.i18n;

import cn.sinozg.applet.common.holder.UserContextHolder;
import org.apache.commons.collections4.CollectionUtils;
import org.jetbrains.annotations.NotNull;
import org.springframework.web.servlet.LocaleResolver;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;

/**
* 国际化配置
* @Author: xyb
* @Description: 
* @Date: 2023-03-26 下午 08:47
**/
public class AppletLocaleResolver implements LocaleResolver {

    private Locale defaultLocale;

    private final List<Locale> supportLocales = new ArrayList<>();

    public AppletLocaleResolver(){
    }

    public void setDefaultLocale(@NotNull Locale defaultLocale) {
        this.defaultLocale = defaultLocale;
    }

    public void setSupportLocales (List<Locale> locales){
        supportLocales.clear();
        supportLocales.addAll(locales);
    }

    public List<Locale> getSupportLocales() {
        return supportLocales;
    }

    @NotNull
    @Override
    public Locale resolveLocale(@NotNull HttpServletRequest request) {
        Locale requestLocale = UserContextHolder.getLocale(request);
        if (requestLocale != null && CollectionUtils.isNotEmpty(supportLocales)
                && supportLocales.contains(requestLocale)) {
            return requestLocale;
        }
        return defaultLocale;
    }

    @Override
    public void setLocale(@NotNull HttpServletRequest request, HttpServletResponse response, Locale locale) {
    }
}
