package cn.sinozg.applet.common.runner;

import cn.sinozg.applet.common.service.FrameworkInitDataService;
import cn.sinozg.applet.common.service.FrameworkInitRunService;
import cn.sinozg.applet.common.utils.PojoUtil;
import cn.sinozg.applet.common.utils.SpringUtil;
import jakarta.annotation.Resource;
import org.apache.commons.collections4.MapUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.CommandLineRunner;
import org.springframework.context.annotation.Configuration;

import java.util.Map;

/**
 * 系统启动后加载的参数
 * @Author: xyb
 * @Description:
 * @Date: 2022-11-26 下午 06:33
 **/
@Configuration
public class InitDataRunner implements CommandLineRunner {

    @Resource
    private FrameworkInitDataService service;

    private final Logger log = LoggerFactory.getLogger(InitDataRunner.class);

    /**
     * 启动加载
     * @param args 参数
     * @throws Exception 异常
     */
    @Override
    public void run(String... args) throws Exception {
        log.info("初始化系统参数。。。。");
        service.cacheSystemData();
        service.initSystemInfo();
        // 其他的接口
        Map<String, FrameworkInitRunService> serviceMap = SpringUtil.beansOfType(FrameworkInitRunService.class);
        if (MapUtils.isNotEmpty(serviceMap)) {
            serviceMap.forEach((k, v) -> v.initInfo());
        }
    }
}