/*
 * Decompiled with CFR 0.152.
 */
package cn.sinozg.applet.common.interceptor;

import cn.sinozg.applet.common.core.base.BasePageResponse;
import cn.sinozg.applet.common.core.base.BaseResponse;
import cn.sinozg.applet.common.holder.MdcContextHolder;
import cn.sinozg.applet.common.properties.AppValue;
import cn.sinozg.applet.common.service.CipherService;
import jakarta.annotation.Resource;
import jakarta.servlet.http.HttpServletRequest;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.MethodParameter;
import org.springframework.core.annotation.Order;
import org.springframework.http.MediaType;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.http.server.ServerHttpRequest;
import org.springframework.http.server.ServerHttpResponse;
import org.springframework.http.server.ServletServerHttpRequest;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.servlet.mvc.method.annotation.ResponseBodyAdvice;

@Order(value=2)
@ControllerAdvice
public class ResponseBodyAdviceAdapter
implements ResponseBodyAdvice<Object> {
    @Resource
    private AppValue app;
    @Resource
    private CipherService cipherService;
    private final Logger log = LoggerFactory.getLogger(ResponseBodyAdviceAdapter.class);

    public Object beforeBodyWrite(Object o, @NotNull MethodParameter mp, @NotNull MediaType t, @NotNull Class<? extends HttpMessageConverter<?>> c, @NotNull ServerHttpRequest q, @NotNull ServerHttpResponse p) {
        BaseResponse response = (BaseResponse)o;
        if (StringUtils.isBlank((CharSequence)response.getBizStatus())) {
            response.setBizStatus(response.getErrorInfo() == null ? "00" : "01");
        }
        response.setTraceId(MdcContextHolder.get());
        if (this.app.getSign().isCryptoEnable()) {
            ServletServerHttpRequest httpRequest = (ServletServerHttpRequest)q;
            HttpServletRequest request = httpRequest.getServletRequest();
            try {
                return this.cipherService.encryptJson(request, (Object)response);
            }
            catch (Exception e) {
                this.log.error("\u63a5\u53e3\u3010{}\u3011\uff0c\u8fd4\u56de\u6570\u636e\u8fdb\u884c\u52a0\u5bc6\u5f02\u5e38\uff0c{}\uff01", (Object)Objects.requireNonNull(mp.getMethod()).getName(), (Object)e.getMessage());
            }
        }
        return o;
    }

    public boolean supports(@NotNull MethodParameter p, @NotNull Class<? extends HttpMessageConverter<?>> c) {
        boolean flag = false;
        try {
            Class cl = p.getParameterType();
            flag = cl.isAssignableFrom(BaseResponse.class) || cl.isAssignableFrom(BasePageResponse.class) || cl.isAssignableFrom(Void.TYPE);
        }
        catch (Exception e) {
            this.log.error("\u8fd4\u56de\u53c2\u6570\u62e6\u622a\u5668\u83b7\u53d6\u8fd4\u56de\u53c2\u6570\u7c7b\u578b\u9519\u8bef\uff0c", (Throwable)e);
        }
        return flag;
    }
}

