/*
 * Copyright (C) 2020-2024, Xie YuBin
 * The GNU Free Documentation License covers this file. The original version
 * of this license can be found at http://www.gnu.org/licenses/gfdl.html.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Free Documentation License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Free Documentation License for more details.
 *
 * You should have received a copy of the GNU Free Documentation License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */

package cn.sinozg.applet.biz.system.vo.request;

import com.fasterxml.jackson.annotation.JsonIgnore;
import io.swagger.v3.oas.annotations.media.Schema;

/**
 * @Author: xyb
 * @Description:
 * @Date: 2022-11-21 上午 10:51
 **/
public class LoginInfoPageListRequest {

    /** 登录IP地址 */
    @Schema(description = "登录IP地址")
    private String ipaddr;

    /** 操作状态;00正常 01异常 */
    @Schema(description = "操作状态;00正常 01异常")
    private String dataStatus;
    /** 登录类型，00 登录，01登出 */
    @Schema(description = "登录类型，00 登录，01登出")
    private String loginType;
    /** 用户账号 */
    @Schema(description = "用户账号")
    private String userName;
    /** 开始时间 */
    @Schema(description = "开始时间 yyyy-MM-dd")
    private String beginTime;
    /** 结束时间 */
    @Schema(description = "结束时间 yyyy-MM-dd")
    private String endTime;
    /** NAME 的子sql 语句 */
    @JsonIgnore
    private String nameSql;
    /** 租户 */
    @JsonIgnore
    private String tenantId;

    /**
     * 获取 登录IP地址
     *
     * @return ipaddr 登录IP地址
     */
    public String getIpaddr() {
        return this.ipaddr;
    }

    /**
     * 设置 登录IP地址
     *
     * @param ipaddr 登录IP地址
     */
    public void setIpaddr(String ipaddr) {
        this.ipaddr = ipaddr;
    }

    /**
     * 获取 操作状态;00正常 01异常
     *
     * @return dataStatus 操作状态;00正常 01异常
     */
    public String getDataStatus() {
        return this.dataStatus;
    }

    /**
     * 设置 操作状态;00正常 01异常
     *
     * @param dataStatus 操作状态;00正常 01异常
     */
    public void setDataStatus(String dataStatus) {
        this.dataStatus = dataStatus;
    }

    /**
     * 获取 登录类型，00 登录，01登出
     *
     * @return loginType 登录类型，00 登录，01登出
     */
    public String getLoginType() {
        return this.loginType;
    }

    /**
     * 设置 登录类型，00 登录，01登出
     *
     * @param loginType 登录类型，00 登录，01登出
     */
    public void setLoginType(String loginType) {
        this.loginType = loginType;
    }

    /**
     * 获取 用户账号
     *
     * @return userName 用户账号
     */
    public String getUserName() {
        return this.userName;
    }

    /**
     * 设置 用户账号
     *
     * @param userName 用户账号
     */
    public void setUserName(String userName) {
        this.userName = userName;
    }

    /**
     * 获取 开始时间
     *
     * @return beginTime 开始时间
     */
    public String getBeginTime() {
        return this.beginTime;
    }

    /**
     * 设置 开始时间
     *
     * @param beginTime 开始时间
     */
    public void setBeginTime(String beginTime) {
        this.beginTime = beginTime;
    }

    /**
     * 获取 结束时间
     *
     * @return endTime 结束时间
     */
    public String getEndTime() {
        return this.endTime;
    }

    /**
     * 设置 结束时间
     *
     * @param endTime 结束时间
     */
    public void setEndTime(String endTime) {
        this.endTime = endTime;
    }

    /**
     * 获取 NAME 的子sql 语句
     *
     * @return nameSql NAME 的子sql 语句
     */
    public String getNameSql() {
        return this.nameSql;
    }

    /**
     * 设置 NAME 的子sql 语句
     *
     * @param nameSql NAME 的子sql 语句
     */
    public void setNameSql(String nameSql) {
        this.nameSql = nameSql;
    }

    /**
     * 获取 租户
     *
     * @return tenantId 租户
     */
    public String getTenantId() {
        return this.tenantId;
    }

    /**
     * 设置 租户
     *
     * @param tenantId 租户
     */
    public void setTenantId(String tenantId) {
        this.tenantId = tenantId;
    }
}