/*
 * Decompiled with CFR 0.152.
 */
package cn.sinozg.applet.common.filter;

import jakarta.servlet.ReadListener;
import jakarta.servlet.ServletInputStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WrapperInputStream
extends ServletInputStream {
    private final InputStream cacheInputStream;
    private final Logger log = LoggerFactory.getLogger(WrapperInputStream.class);

    public WrapperInputStream(byte[] body) {
        this.cacheInputStream = new ByteArrayInputStream(body);
    }

    public boolean isFinished() {
        try {
            return this.cacheInputStream.available() == 0;
        }
        catch (Exception e) {
            this.log.error("\u7f13\u5b58\u8bf7\u6c42\u53c2\u6570\u6d41 \u5f02\u5e38\uff0c{}", (Object)e.getMessage());
            return false;
        }
    }

    public boolean isReady() {
        return true;
    }

    public void setReadListener(ReadListener readListener) {
    }

    public int read() throws IOException {
        return this.cacheInputStream.read();
    }
}

