/*
 * Copyright (C) 2020-2024, Xie YuBin
 * The GNU Free Documentation License covers this file. The original version
 * of this license can be found at http://www.gnu.org/licenses/gfdl.html.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Free Documentation License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Free Documentation License for more details.
 *
 * You should have received a copy of the GNU Free Documentation License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */

package cn.sinozg.applet.common.config;

import cn.sinozg.applet.common.constant.BaseConstants;
import cn.sinozg.applet.common.i18n.AppletLocaleResolver;
import cn.sinozg.applet.common.utils.I18nBaseUtil;
import cn.sinozg.applet.common.utils.PojoUtil;
import jakarta.validation.Validator;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.MessageSource;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.support.ResourceBundleMessageSource;
import org.springframework.validation.beanvalidation.LocalValidatorFactoryBean;

import java.util.List;
import java.util.Locale;

/**
 * 国际化配置
 * @Author: xyb
 * @Description:
 * @Date: 2023-03-26 下午 08:48
 **/
@Configuration
@ConfigurationProperties(prefix = "spring.messages")
public class Ii8nConfig {

    private List<String> basename;

    private String encoding;

    @Bean
    public MessageSource messageSource(){
        ResourceBundleMessageSource source = new ResourceBundleMessageSource();
        source.setBasenames(PojoUtil.toArray(basename, String.class));
        source.setDefaultEncoding(encoding);
        return source;
    }

    @Bean
    public Validator validator(){
        LocalValidatorFactoryBean factory = new LocalValidatorFactoryBean();
        factory.setValidationMessageSource(messageSource());
        return factory;
    }

    @Bean(name = BaseConstants.LOCALE_RESOLVER)
    public AppletLocaleResolver resolver(){
        AppletLocaleResolver resolver = new AppletLocaleResolver();
        resolver.setDefaultLocale(Locale.CHINA);
        resolver.setSupportLocales(I18nBaseUtil.supportLocales());
        return resolver;
    }

    public void setBasename(List<String> basename) {
        this.basename = basename;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }
}
