/*
 * Decompiled with CFR 0.152.
 */
package cn.sinozg.applet.common.config;

import cn.sinozg.applet.common.filter.WrapperFilter;
import cn.sinozg.applet.common.interceptor.ParamsInterceptor;
import cn.sinozg.applet.common.properties.ApiUrlValue;
import cn.sinozg.applet.common.properties.AppValue;
import cn.sinozg.applet.common.service.CipherService;
import cn.sinozg.applet.common.service.FrameworkAuthService;
import cn.sinozg.applet.common.service.FrameworkInitDataService;
import cn.sinozg.applet.common.service.FrameworkTenantService;
import jakarta.annotation.Resource;
import jakarta.servlet.Filter;
import java.util.Collection;
import org.apache.commons.collections4.CollectionUtils;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.web.servlet.FilterRegistrationBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.config.annotation.InterceptorRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;

@Configuration
public class SystemWebConfig
implements WebMvcConfigurer {
    @Resource
    private AppValue app;
    @Resource
    private CipherService cipherService;
    @Resource
    private ParamsInterceptor paramsInterceptor;
    @Resource
    private FrameworkInitDataService initDataService;
    @Resource
    private FrameworkAuthService authService;
    @Resource
    private FrameworkTenantService tenantService;
    private final Logger log = LoggerFactory.getLogger(SystemWebConfig.class);

    public void addInterceptors(@NotNull InterceptorRegistry registry) {
        HandlerInterceptor authInterceptor;
        this.log.info("addInterceptors");
        ApiUrlValue apiUrl = this.app.getApiUrl();
        if (CollectionUtils.isNotEmpty((Collection)apiUrl.getParamsPatterns())) {
            registry.addInterceptor((HandlerInterceptor)this.paramsInterceptor).addPathPatterns(apiUrl.getParamsPatterns());
        }
        if ((authInterceptor = this.authService.authInterceptor()) != null) {
            registry.addInterceptor(authInterceptor).addPathPatterns(apiUrl.getAuthPatterns()).excludePathPatterns(apiUrl.getAuthExcludePath());
        }
        this.tenantService.expiredCheckInterceptor(registry);
        this.initDataService.addCustomInterceptor(registry);
    }

    @Bean
    public FilterRegistrationBean<WrapperFilter> registrationBean() {
        ApiUrlValue apiUrl = this.app.getApiUrl();
        FilterRegistrationBean bean = new FilterRegistrationBean();
        bean.setFilter((Filter)new WrapperFilter(this.app, this.cipherService));
        bean.addUrlPatterns(new String[]{apiUrl.getWrapperUrl()});
        return bean;
    }
}

