/*
 * Decompiled with CFR 0.152.
 */
package cn.sinozg.applet.common.interceptor;

import cn.sinozg.applet.common.annotation.RepeatSubmit;
import cn.sinozg.applet.common.filter.WrapperRequest;
import cn.sinozg.applet.common.holder.UserContextHolder;
import cn.sinozg.applet.common.properties.AppValue;
import cn.sinozg.applet.common.service.CipherService;
import cn.sinozg.applet.common.service.FrameworkAuthService;
import cn.sinozg.applet.common.utils.CypherUtil;
import cn.sinozg.applet.common.utils.JsonUtil;
import cn.sinozg.applet.common.utils.MsgUtil;
import cn.sinozg.applet.common.utils.PojoUtil;
import cn.sinozg.applet.common.utils.RedisUtil;
import cn.sinozg.applet.common.utils.TirsciUtil;
import cn.sinozg.applet.common.utils.WebUtil;
import jakarta.annotation.Resource;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletRequestWrapper;
import jakarta.servlet.http.HttpServletResponse;
import java.lang.reflect.Method;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Component;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.HandlerMapping;
import org.springframework.web.servlet.ModelAndView;

@Component
public class ParamsInterceptor
implements HandlerInterceptor {
    @Resource
    private AppValue app;
    @Resource
    private CipherService cipherService;
    @Resource
    private FrameworkAuthService tokenService;
    private final Logger log = LoggerFactory.getLogger(ParamsInterceptor.class);

    public boolean preHandle(@NotNull HttpServletRequest request, @NotNull HttpServletResponse response, @NotNull Object handler) throws Exception {
        if (HttpMethod.OPTIONS.matches(request.getMethod())) {
            response.setStatus(HttpStatus.NO_CONTENT.value());
            return false;
        }
        UserContextHolder.setInfo((HttpServletRequest)request);
        if (!(handler instanceof HandlerMethod)) {
            return true;
        }
        HandlerMethod handlerMethod = (HandlerMethod)handler;
        String params = this.wrapperBody(request);
        if (StringUtils.isEmpty((CharSequence)params) && HttpMethod.GET.name().equals(request.getMethod())) {
            params = this.getRequestParams(request);
            this.log.info("get \u8bf7\u6c42 \u7684\u53c2\u6570\u4e3a {}", (Object)params);
        }
        if (StringUtils.isBlank((CharSequence)params)) {
            params = "{}";
        }
        Method method = handlerMethod.getMethod();
        if (this.app.getSign().isSignEnable() && !this.signParams(request, response, params)) {
            return false;
        }
        RepeatSubmit rs = method.getAnnotation(RepeatSubmit.class);
        if (rs != null && this.isRepeatSubmit(request, rs, params)) {
            this.httpError(request, response, "BIZ000100016");
            return false;
        }
        return true;
    }

    public void postHandle(@NotNull HttpServletRequest request, @NotNull HttpServletResponse response, @NotNull Object handler, ModelAndView modelAndView) throws Exception {
        super.postHandle(request, response, handler, modelAndView);
    }

    public void afterCompletion(@NotNull HttpServletRequest request, @NotNull HttpServletResponse response, @NotNull Object handler, Exception ex) throws Exception {
        UserContextHolder.clear();
    }

    private String getRequestParams(HttpServletRequest request) {
        Map urlPathMap = (Map)PojoUtil.cast((Object)request.getAttribute(HandlerMapping.URI_TEMPLATE_VARIABLES_ATTRIBUTE));
        Map paramsMap = request.getParameterMap();
        TreeMap jsonMap = new TreeMap(Comparator.naturalOrder());
        for (Map.Entry e : paramsMap.entrySet()) {
            Object[] arrays = (String[])e.getValue();
            Arrays.sort(arrays);
            jsonMap.put((String)e.getKey(), arrays);
        }
        if (MapUtils.isNotEmpty((Map)urlPathMap)) {
            ArrayList list = new ArrayList();
            urlPathMap.forEach((k, v) -> list.add(v));
            list.sort(String::compareTo);
            jsonMap.put("get_url_path_param", (String[])PojoUtil.toArray(list, String.class));
        }
        return JsonUtil.toJson(jsonMap);
    }

    private boolean signParams(HttpServletRequest request, HttpServletResponse response, String params) {
        String time;
        String signature;
        String nonce = request.getHeader("Whj-Nonce");
        if (StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{nonce, signature = request.getHeader("Whj-Signature"), time = StringUtils.trimToEmpty((String)request.getHeader("Whj-Timestamp"))})) {
            this.httpError(request, response, "BIZ000100019");
            return false;
        }
        long now = System.currentTimeMillis() / 1000L;
        int signMaxTime = this.app.getSign().getSignExpTime();
        Long timestamp = (Long)TirsciUtil.tryCatch(() -> Long.parseLong(time));
        if (timestamp == null || Math.abs(now - timestamp) > (long)signMaxTime) {
            this.httpError(request, response, "BIZ000100020");
            return false;
        }
        String redisKey = String.format("jby:biz:params_none:%s", nonce);
        boolean exists = RedisUtil.setIfAbsentObject((String)redisKey, (Object)nonce, (Duration)Duration.ofSeconds(signMaxTime));
        if (!exists) {
            this.httpError(request, response, "BIZ000100021");
            return false;
        }
        boolean accept = this.cipherService.signature(true, signature, new String[]{nonce, time, params});
        if (!accept) {
            this.httpError(request, response, "BIZ000100022");
            return false;
        }
        return true;
    }

    private boolean isRepeatSubmit(HttpServletRequest request, RepeatSubmit rs, String json) {
        String cacheRepeatKey;
        long time;
        String params = "{}";
        if (rs.withParams()) {
            params = json;
        }
        String paramsMd5 = CypherUtil.md5((String)params);
        String url = request.getRequestURI();
        String submitKey = this.tokenService.token();
        if (StringUtils.isEmpty((CharSequence)submitKey)) {
            submitKey = url;
        }
        return (time = RedisUtil.getIncr((String)(cacheRepeatKey = String.format("jby:biz:repeat_submit:%s:%s", submitKey, paramsMd5)), (Duration)Duration.ofSeconds(10L))) >= (long)rs.times();
    }

    private void httpError(HttpServletRequest request, HttpServletResponse response, String code) {
        MsgUtil.httpError((HttpServletResponse)response, (HttpServletRequest)request, null, (HttpStatus)HttpStatus.OK, (String)code, (Object[])new Object[]{null});
    }

    private String wrapperBody(HttpServletRequest request) {
        HttpServletRequest r = request;
        while (r instanceof HttpServletRequestWrapper) {
            HttpServletRequestWrapper wrapper = (HttpServletRequestWrapper)r;
            if (r instanceof WrapperRequest) {
                return WebUtil.getBodyString((ServletRequest)r);
            }
            r = (HttpServletRequest)wrapper.getRequest();
        }
        return "";
    }
}

