/*
 * Copyright (C) 2020-2024, Xie YuBin
 * The GNU Free Documentation License covers this file. The original version
 * of this license can be found at http://www.gnu.org/licenses/gfdl.html.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Free Documentation License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Free Documentation License for more details.
 *
 * You should have received a copy of the GNU Free Documentation License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */

package cn.sinozg.applet.biz.system.mapper;

import cn.sinozg.applet.biz.system.entity.LoginInfo;
import cn.sinozg.applet.biz.system.vo.request.LoginInfoPageListRequest;
import cn.sinozg.applet.biz.system.vo.response.LoginInfoPageListResponse;
import cn.sinozg.applet.common.constant.BaseConstants;
import com.baomidou.mybatisplus.annotation.InterceptorIgnore;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import java.util.List;
import org.apache.ibatis.annotations.Param;

/**
* 系统访问记录 Mapper 接口
* @Description
* @Copyright Copyright (c) 2022
* @Author: xyb
* @since 2022-09-14 12:51:35
*/
public interface LoginInfoMapper extends BaseMapper<LoginInfo> {

    /**
     * 查询系统登录日志集合
     * @param page 分页
     * @param loginInfo 访问日志对象
     * @return 登录记录集合
     */
    @InterceptorIgnore(tenantLine = BaseConstants.IGNORE)
    IPage<LoginInfoPageListResponse> selectLoginInfoPage(Page<LoginInfoPageListResponse> page, @Param("p") LoginInfoPageListRequest loginInfo);

    /**
     * 查询登陆日志
     * @param loginInfo 查询参数
     * @return 登录日志
     */
    @InterceptorIgnore(tenantLine = BaseConstants.IGNORE)
    List<LoginInfoPageListResponse> list(@Param("p") LoginInfoPageListRequest loginInfo);

    /**
     * 清空系统登录日志
     *
     * @return 结果
     */
    int cleanLoginInfo();
}
