/*
 * Copyright (C) 2020-2024, Xie YuBin
 * The GNU Free Documentation License covers this file. The original version
 * of this license can be found at http://www.gnu.org/licenses/gfdl.html.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Free Documentation License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Free Documentation License for more details.
 *
 * You should have received a copy of the GNU Free Documentation License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */

package cn.sinozg.applet.common.controler;

import cn.sinozg.applet.common.constant.BaseConstants;
import cn.sinozg.applet.common.core.base.BaseResponse;
import cn.sinozg.applet.common.utils.MsgUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.web.servlet.error.ErrorController;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;

/**
* 重写 error错误 返回统一的返回格式
 * 解决sa-token 把异常捕获的问题 直接error
* @Author: xyb
* @Description:
* @Date: 2023-01-16 下午 02:19
**/
@RestController
public class JsonErrorController implements ErrorController {

    private final static String ERROR_PATH = "/error";

    private final Logger log = LoggerFactory.getLogger(JsonErrorController.class);

    /**
     * 重写系统error
     * @param response HttpServletResponse
     * @param request HttpServletRequest
     * @return 统一返回格式
     */
    @ResponseBody
    @RequestMapping(value = ERROR_PATH, method = {RequestMethod.GET, RequestMethod.POST}, produces = BaseConstants.APPLICATION_JSON)
    public BaseResponse<String> errorJson(HttpServletResponse response, HttpServletRequest request) {
        int status = response.getStatus();
        String code = BaseConstants.GLOBAL_EXCEPTION_MESSAGE;
        String message = null;
        if (status == HttpStatus.NOT_FOUND.value()) {
            code = BaseConstants.DEFAULT_CODE;
            message = "Not Found!";
        }
        return MsgUtil.error(request, null, code, message);
    }
}
