/*
 * Decompiled with CFR 0.152.
 */
package cn.sinozg.applet.common.config;

import cn.sinozg.applet.common.i18n.AppletLocaleResolver;
import cn.sinozg.applet.common.utils.I18nBaseUtil;
import cn.sinozg.applet.common.utils.PojoUtil;
import jakarta.validation.Validator;
import java.util.List;
import java.util.Locale;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.MessageSource;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.support.ResourceBundleMessageSource;
import org.springframework.validation.beanvalidation.LocalValidatorFactoryBean;

@Configuration
@ConfigurationProperties(prefix="spring.messages")
public class I18nConfig {
    private List<String> basename;
    private String encoding;

    @Bean
    public MessageSource messageSource() {
        ResourceBundleMessageSource source = new ResourceBundleMessageSource();
        source.setBasenames((String[])PojoUtil.toArray(this.basename, String.class));
        source.setDefaultEncoding(this.encoding);
        return source;
    }

    @Bean
    public Validator validator() {
        LocalValidatorFactoryBean factory = new LocalValidatorFactoryBean();
        factory.setValidationMessageSource(this.messageSource());
        return factory;
    }

    @Bean(name={"appletLocaleResolver"})
    public AppletLocaleResolver resolver() {
        AppletLocaleResolver resolver = new AppletLocaleResolver();
        resolver.setDefaultLocale(Locale.CHINA);
        resolver.setSupportLocales(I18nBaseUtil.supportLocales());
        return resolver;
    }

    public void setBasename(List<String> basename) {
        this.basename = basename;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }
}

