/*
 * Decompiled with CFR 0.152.
 */
package cn.sinozg.applet.common.config;

import cn.sinozg.applet.common.properties.AppValue;
import io.swagger.v3.core.util.PrimitiveType;
import io.swagger.v3.oas.annotations.enums.ParameterIn;
import io.swagger.v3.oas.models.Components;
import io.swagger.v3.oas.models.ExternalDocumentation;
import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.info.Contact;
import io.swagger.v3.oas.models.info.Info;
import io.swagger.v3.oas.models.info.License;
import io.swagger.v3.oas.models.parameters.Parameter;
import io.swagger.v3.oas.models.security.SecurityRequirement;
import io.swagger.v3.oas.models.security.SecurityScheme;
import jakarta.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springdoc.core.customizers.OperationCustomizer;
import org.springdoc.core.models.GroupedOpenApi;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConditionalOnProperty(name={"springdoc.api-docs.enabled"}, matchIfMissing=true)
public class SwaggerConfig {
    @Resource
    private AppValue app;
    private final Logger log = LoggerFactory.getLogger(SwaggerConfig.class);
    private static final String URL = "https://www.jiubankeji.cn";

    @Bean
    public OperationCustomizer customize() {
        PrimitiveType.enablePartialTime();
        return (o, h) -> o.addParametersItem(new Parameter().in(ParameterIn.HEADER.toString()).required(Boolean.valueOf(false)).description("\u7528\u6237id").name("UserId"));
    }

    @Bean
    public GroupedOpenApi publicApi() {
        return GroupedOpenApi.builder().group("SwaggerAPI").pathsToMatch(new String[]{"/**"}).build();
    }

    @Bean
    public OpenAPI springShopOpenApi() {
        String securitySchemeName = "Authorization OAuth2";
        return new OpenAPI().info(new Info().title("\u9879\u76ee\u63a5\u53e3\u6587\u6863").description(StringUtils.trimToEmpty((String)this.app.getDescription()) + " \u63a5\u53e3\u4fe1\u606f").version(this.app.getVersion()).contact(new Contact().name("Wuhan Jubilant Cloud Technology Co., Ltd.").email("xie.y.bin@163.com").url(URL)).license(new License().name("Apache 2.0").url("https://springdoc.org/"))).externalDocs(new ExternalDocumentation().description("Swagger Api Documentation").url(URL)).addSecurityItem(new SecurityRequirement().addList(securitySchemeName)).components(new Components().addSecuritySchemes(securitySchemeName, new SecurityScheme().name(securitySchemeName).type(SecurityScheme.Type.APIKEY).in(SecurityScheme.In.HEADER).description("OAuth2 token flow.")));
    }
}

