/*
 * Decompiled with CFR 0.152.
 */
package cn.sinozg.applet.common.filter;

import cn.sinozg.applet.common.filter.WrapperRequest;
import cn.sinozg.applet.common.holder.MdcContextHolder;
import cn.sinozg.applet.common.properties.AppValue;
import cn.sinozg.applet.common.service.CipherService;
import cn.sinozg.applet.common.utils.PojoWebUtil;
import jakarta.servlet.Filter;
import jakarta.servlet.FilterChain;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.AntPathMatcher;

public class WrapperFilter
implements Filter {
    private AppValue app;
    private CipherService cipherService;
    private final Logger log = LoggerFactory.getLogger(WrapperFilter.class);

    public WrapperFilter() {
    }

    public WrapperFilter(AppValue app, CipherService cipherService) {
        this.app = app;
        this.cipherService = cipherService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        Object servletRequest = null;
        try {
            if (request instanceof HttpServletRequest) {
                HttpServletRequest hsr = (HttpServletRequest)request;
                String traceId = hsr.getHeader("Whj-Trace-Id");
                MdcContextHolder.put((String)traceId);
                if (this.isWrapper(hsr)) {
                    try {
                        servletRequest = new WrapperRequest(hsr, response, this.app.getSign(), this.cipherService);
                    }
                    catch (Exception e) {
                        this.log.error("\u5305\u88c5\u8bf7\u6c42\u53c2\u6570\u5931\u8d25\uff01", (Throwable)e);
                        PojoWebUtil.resolveException((HttpServletRequest)hsr, (HttpServletResponse)((HttpServletResponse)response), (Exception)new RuntimeException("Decryption parameter exception!"));
                        MdcContextHolder.clear();
                        return;
                    }
                }
            }
            if (servletRequest == null) {
                servletRequest = request;
            }
            chain.doFilter(servletRequest, response);
        }
        finally {
            MdcContextHolder.clear();
        }
    }

    private boolean isWrapper(HttpServletRequest request) {
        boolean isWrapper = this.app.getApiUrl().isWrapperEnable();
        if (isWrapper) {
            String contentType = StringUtils.substringBefore((String)request.getContentType(), (String)";");
            isWrapper = StringUtils.equalsAnyIgnoreCase((CharSequence)contentType, (CharSequence[])new CharSequence[]{"application/json", "application/json; charset=utf-8"});
        }
        List urls = this.app.getApiUrl().getWrapperExcludeUrl();
        if (isWrapper && CollectionUtils.isNotEmpty((Collection)urls)) {
            String url = request.getServletPath();
            AntPathMatcher pathMatcher = new AntPathMatcher();
            for (String s : urls) {
                if (!pathMatcher.match(s, url)) continue;
                return false;
            }
        }
        return isWrapper;
    }
}

