package cn.sinozg.applet.common.controller;

import cn.sinozg.applet.common.constant.BaseRedisKeys;
import cn.sinozg.applet.common.core.base.BaseResponse;
import cn.sinozg.applet.common.utils.MsgUtil;
import cn.sinozg.applet.common.utils.RedisUtil;
import cn.sinozg.applet.common.utils.SnowFlake;
import io.swagger.v3.oas.annotations.Operation;
import org.apache.commons.lang3.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * @author xieyubin
 * @Description
 * @Copyright Copyright (c) 2025
 * @since 2025-07-10 20:28
 */
@RestController
@RequestMapping("/api/anon")
public class VersionController {

    @PostMapping("/version")
    @Operation(summary = "版本号")
    public BaseResponse<String> version() {
        String key = BaseRedisKeys.APP_VERSION;
        String version = RedisUtil.getCacheObject(key);
        if (StringUtils.isBlank(version)) {
            version = SnowFlake.genId();
            RedisUtil.setCacheObject(key, version);
        }
        return MsgUtil.ok(version);
    }
}
