/*
 * Copyright (C) 2020-2024, Xie YuBin
 * The GNU Free Documentation License covers this file. The original version
 * of this license can be found at http://www.gnu.org/licenses/gfdl.html.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Free Documentation License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Free Documentation License for more details.
 *
 * You should have received a copy of the GNU Free Documentation License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */

package cn.sinozg.applet.common.runner;

import cn.sinozg.applet.common.constant.BaseRedisKeys;
import cn.sinozg.applet.common.service.FrameworkInitDataService;
import cn.sinozg.applet.common.service.FrameworkInitRunService;
import cn.sinozg.applet.common.utils.RedisUtil;
import cn.sinozg.applet.common.utils.SpringUtil;
import jakarta.annotation.Resource;
import org.apache.commons.collections4.MapUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.CommandLineRunner;
import org.springframework.context.annotation.Configuration;

import java.util.Map;

/**
 * 系统启动后加载的参数
 * @Author: xyb
 * @Description:
 * @Date: 2022-11-26 下午 06:33
 **/
@Configuration
public class InitDataRunner implements CommandLineRunner {

    @Resource
    private FrameworkInitDataService service;

    private final Logger log = LoggerFactory.getLogger(InitDataRunner.class);

    /**
     * 启动加载
     * @param args 参数
     * @throws Exception 异常
     */
    @Override
    public void run(String... args) throws Exception {
        log.info("初始化系统参数。。。。");
        RedisUtil.deleteObject(BaseRedisKeys.APP_VERSION);
        service.cacheSystemData();
        service.initSystemInfo();
        // 其他的接口 因为使用的是function，在没有实现类的时候，使用注入的方式会报错，所以此处使用静态获取
        Map<String, FrameworkInitRunService> serviceMap = SpringUtil.beansOfType(FrameworkInitRunService.class);
        if (MapUtils.isNotEmpty(serviceMap)) {
            serviceMap.forEach((k, v) -> v.initInfo());
        }
    }
}