/*
 * Decompiled with CFR 0.152.
 */
package cn.sinozg.applet.biz.framework.cleanup;

import cn.sinozg.applet.common.function.FunctionException;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Component;

@Component
public class LogCleanupAsync {
    private static final Logger log = LoggerFactory.getLogger(LogCleanupAsync.class);

    @Async
    public <T> void logCleanup(String name, int maxRetries, T params, FunctionException<T, Long> del) {
        long count = 1L;
        int retryCount = 0;
        while (count > 0L) {
            try {
                count = (Long)del.apply(params);
                retryCount = 0;
                TimeUnit.MILLISECONDS.sleep(100L);
            }
            catch (Exception e) {
                log.error("\u5220\u9664{}\u65e5\u5fd7\u5931\u8d25: {}\uff0c\u9519\u8bef: {}", new Object[]{name, e.getMessage(), e});
                if (++retryCount >= maxRetries) {
                    log.error("{} \u6700\u5927\u91cd\u8bd5\u6b21\u6570\u5230\u8fbe\uff0c\u505c\u6b62\u5220\u9664\u65e5\u5fd7", (Object)name);
                    break;
                }
                try {
                    TimeUnit.MILLISECONDS.sleep(2000L);
                }
                catch (InterruptedException ie) {
                    Thread.currentThread().interrupt();
                }
            }
        }
    }
}

