/*
 * Copyright (C) 2020-2024, Xie YuBin
 * The GNU Free Documentation License covers this file. The original version
 * of this license can be found at http://www.gnu.org/licenses/gfdl.html.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Free Documentation License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Free Documentation License for more details.
 *
 * You should have received a copy of the GNU Free Documentation License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */

package cn.sinozg.applet.biz.framework.service.impl;

import cn.sinozg.applet.common.service.FrameworkInitRunService;
import cn.sinozg.applet.common.utils.VerifyUtil;
import jakarta.annotation.Resource;
import jakarta.validation.Validator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.validation.beanvalidation.LocalValidatorFactoryBean;

/**
 * @author xieyubin
 * @Description
 * @Copyright Copyright (c) 2025
 * @since 2025-08-01 22:06
 */
@Service
public class SpringValidatorFrameworkInitRunService implements FrameworkInitRunService {

    private static final Logger log = LoggerFactory.getLogger(SpringValidatorFrameworkInitRunService.class);
    @Resource
    private Validator validator;

    @Override
    public void initInfo() {
        LocalValidatorFactoryBean factoryBean = (LocalValidatorFactoryBean) validator;
        VerifyUtil.springValidator(factoryBean.getMessageInterpolator());
    }
}
