/*
 * Copyright (C) 2020-2024, Xie YuBin
 * The GNU Free Documentation License covers this file. The original version
 * of this license can be found at http://www.gnu.org/licenses/gfdl.html.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Free Documentation License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Free Documentation License for more details.
 *
 * You should have received a copy of the GNU Free Documentation License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */

package cn.sinozg.applet.biz.system.mapper;

import cn.sinozg.applet.biz.system.entity.DictData;
import cn.sinozg.applet.biz.system.vo.request.DictDataPageRequest;
import cn.sinozg.applet.common.core.model.DictDataVo;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
* 字典数据表 Mapper 接口
* @Description
* @Copyright Copyright (c) 2022
* @Author: xyb
* @since 2022-09-14 12:51:35
*/
public interface DictDataMapper extends BaseMapper<DictData> {

    /**
     * 查询缓存
     * @return 集合
     */
    List<DictDataVo> dictCache();
    /**
     * 分页查询
     * @param page 分页对象
     * @param params 请求参数
     * @return 分页
     */
    IPage<DictData> pageDictData(Page<DictData> page, @Param("p") DictDataPageRequest params);
}
