/*
 * Copyright (C) 2020-2024, Xie YuBin
 * The GNU Free Documentation License covers this file. The original version
 * of this license can be found at http://www.gnu.org/licenses/gfdl.html.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Free Documentation License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Free Documentation License for more details.
 *
 * You should have received a copy of the GNU Free Documentation License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */

package cn.sinozg.applet.biz.system.service;

import cn.sinozg.applet.biz.system.entity.DictData;
import cn.sinozg.applet.biz.system.vo.request.DictDataPageRequest;
import cn.sinozg.applet.biz.system.vo.response.DictListResponse;
import cn.sinozg.applet.common.core.base.BaseResponse;
import cn.sinozg.applet.common.core.base.PagingRequest;
import cn.sinozg.applet.common.core.model.DictDataVo;
import com.baomidou.mybatisplus.extension.service.IService;
import java.util.List;
import java.util.Map;

/**
 * 字典数据表 服务类
 *
 * @Author: xyb
 * @Description
 * @Copyright Copyright (c) 2022
 * @since 2022-09-14 12:51:35
 */
public interface DictDataService extends IService<DictData> {

    /**
     * 获取到所有的数据字典
     * @return 数据字典集合
     */
    Map<String, List<DictDataVo>> allDictCache();

    /**
     * 获取的某一个类型的数据字典
     * @param type 数据字典类型
     * @return 数据字典集合
     */
    List<DictListResponse> dictList(String type);

    /**
     * 批量查询数据字典
     * @param type 数据字典类型集合
     * @return 数据字典返回的map
     */
    Map<String, List<DictListResponse>> dictLists(List<String> type);

    /**
     * 分页查询
     * @param page 分页
     * @param request 请求参数
     * @return 分页返回结果
     */
    BaseResponse<List<DictData>> dictDataPage (PagingRequest page, DictDataPageRequest request);
}
