/*
 * Copyright (C) 2020-2024, Xie YuBin
 * The GNU Free Documentation License covers this file. The original version
 * of this license can be found at http://www.gnu.org/licenses/gfdl.html.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Free Documentation License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Free Documentation License for more details.
 *
 * You should have received a copy of the GNU Free Documentation License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */

package cn.sinozg.applet.biz.system.service;

import cn.sinozg.applet.biz.system.entity.LoginInfo;
import cn.sinozg.applet.biz.system.vo.request.LoginInfoPageListRequest;
import cn.sinozg.applet.biz.system.vo.response.LoginInfoPageListResponse;
import cn.sinozg.applet.common.core.base.BasePageResponse;
import cn.sinozg.applet.common.core.base.PagingRequest;
import com.baomidou.mybatisplus.extension.service.IService;

import java.util.List;

/**
 * 系统访问记录 服务类
 *
 * @Author: xyb
 * @Description
 * @Copyright Copyright (c) 2022
 * @since 2022-09-14 12:51:35
 */
public interface LoginInfoService extends IService<LoginInfo> {

    /**
     * 查询系统登录日志集合
     * @param page 分页对象
     * @param loginInfo 访问日志对象
     * @return 登录记录集合
     */
    BasePageResponse<List<LoginInfoPageListResponse>> selectLoginInfoPage(PagingRequest page, LoginInfoPageListRequest loginInfo);

    /**
     * 查询系统登录日志集合
     * @param loginInfo 查询参数
     * @return 集合
     */
    List<LoginInfoPageListResponse> list(LoginInfoPageListRequest loginInfo);

    /**
     * 批量删除系统登录日志
     *
     * @param infoIds 需要删除的登录日志ID
     * @return 成功条数
     */
    int deleteLoginInfoByIds(List<String> infoIds);

    /**
     * 清空系统登录日志
     */
    void cleanLoginInfo();
}
