/*
 * Copyright (C) 2020-2024, Xie YuBin
 * The GNU Free Documentation License covers this file. The original version
 * of this license can be found at http://www.gnu.org/licenses/gfdl.html.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Free Documentation License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Free Documentation License for more details.
 *
 * You should have received a copy of the GNU Free Documentation License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */

package cn.sinozg.applet.common.i18n;

import cn.sinozg.applet.common.holder.UserContextHolder;
import org.apache.commons.collections4.CollectionUtils;
import org.jetbrains.annotations.NotNull;
import org.springframework.web.servlet.LocaleResolver;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;

/**
 * 国际化配置
 * @Author: xyb
 * @Description: 
 * @Date: 2023-03-26 下午 08:47
 **/
public class AppletLocaleResolver implements LocaleResolver {

    private Locale defaultLocale;

    private final List<Locale> supportLocales = new ArrayList<>();

    public AppletLocaleResolver(){
    }

    public void setDefaultLocale(@NotNull Locale defaultLocale) {
        this.defaultLocale = defaultLocale;
    }

    public void setSupportLocales (List<Locale> locales){
        supportLocales.clear();
        supportLocales.addAll(locales);
    }

    public List<Locale> getSupportLocales() {
        return supportLocales;
    }

    @NotNull
    @Override
    public Locale resolveLocale(@NotNull HttpServletRequest request) {
        Locale requestLocale = UserContextHolder.getLocale(request);
        if (requestLocale != null && CollectionUtils.isNotEmpty(supportLocales)
                && supportLocales.contains(requestLocale)) {
            return requestLocale;
        }
        return defaultLocale;
    }

    @Override
    public void setLocale(@NotNull HttpServletRequest request, HttpServletResponse response, Locale locale) {
    }
}
