/*
 * Decompiled with CFR 0.152.
 */
package cn.sinozg.applet.common.i18n;

import cn.sinozg.applet.common.holder.UserContextHolder;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.apache.commons.collections4.CollectionUtils;
import org.jetbrains.annotations.NotNull;
import org.springframework.web.servlet.LocaleResolver;

public class AppletLocaleResolver
implements LocaleResolver {
    private Locale defaultLocale;
    private final List<Locale> supportLocales = new ArrayList<Locale>();

    public void setDefaultLocale(@NotNull Locale defaultLocale) {
        this.defaultLocale = defaultLocale;
    }

    public void setSupportLocales(List<Locale> locales) {
        this.supportLocales.clear();
        this.supportLocales.addAll(locales);
    }

    public List<Locale> getSupportLocales() {
        return this.supportLocales;
    }

    @NotNull
    public Locale resolveLocale(@NotNull HttpServletRequest request) {
        Locale requestLocale = UserContextHolder.getLocale((HttpServletRequest)request);
        if (requestLocale != null && CollectionUtils.isNotEmpty(this.supportLocales) && this.supportLocales.contains(requestLocale)) {
            return requestLocale;
        }
        return this.defaultLocale;
    }

    public void setLocale(@NotNull HttpServletRequest request, HttpServletResponse response, Locale locale) {
    }
}

