/*
 * Decompiled with CFR 0.152.
 */
package cn.sinozg.applet.ws.verticles;

import cn.sinozg.applet.common.core.model.LoginUserVo;
import cn.sinozg.applet.common.service.FrameworkAuthService;
import cn.sinozg.applet.common.utils.JsonUtil;
import cn.sinozg.applet.common.utils.PojoUtil;
import cn.sinozg.applet.common.utils.UserUtil;
import cn.sinozg.applet.mq.mq.MqConsumer;
import cn.sinozg.applet.ws.joint.WsBaseEnum;
import cn.sinozg.applet.ws.model.WebSocketData;
import cn.sinozg.applet.ws.model.WebsocketEntity;
import cn.sinozg.applet.ws.properties.WsProperties;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.vertx.core.AbstractVerticle;
import io.vertx.core.AsyncResult;
import io.vertx.core.MultiMap;
import io.vertx.core.VertxOptions;
import io.vertx.core.http.HttpServer;
import io.vertx.core.http.HttpServerOptions;
import io.vertx.core.http.ServerWebSocket;
import io.vertx.core.net.KeyCertOptions;
import io.vertx.core.net.PemKeyCertOptions;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.atomic.LongAdder;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;

public class WebsocketVerticle
extends AbstractVerticle {
    private final WsProperties properties;
    private final MqConsumer<WebSocketData> socketConsumer;
    private final FrameworkAuthService frameworkAuthService;
    private HttpServer httpServer;
    private List<Class<WsBaseEnum>> enumClasses;
    private static final LongAdder LONG_ADDER = new LongAdder();
    private static final Logger log = LoggerFactory.getLogger(WebsocketVerticle.class);

    public WebsocketVerticle(WsProperties properties, MqConsumer<WebSocketData> socketConsumer, FrameworkAuthService authService) {
        this.properties = properties;
        this.socketConsumer = socketConsumer;
        this.frameworkAuthService = authService;
    }

    public void start() throws Exception {
        HttpServerOptions options = new HttpServerOptions().setPort(this.properties.getPort()).setRegisterWebSocketWriteHandlers(true).setWebSocketSubProtocols((List)PojoUtil.arrayToList((Object[])new String[]{"*"}));
        if (this.properties.isSsl()) {
            options = options.setSsl(true).setKeyCertOptions((KeyCertOptions)new PemKeyCertOptions().setKeyPath(this.properties.getSslKey()).setCertPath(this.properties.getSslCert()));
        }
        VertxOptions vertxOptions = new VertxOptions();
        vertxOptions.setWorkerPoolSize(this.properties.getWorkerPoolSize());
        vertxOptions.setInternalBlockingPoolSize(this.properties.getBlockingPoolSize());
        this.httpServer = this.vertx.createHttpServer(options).webSocketHandler(this::websocketHandle).listen(this.properties.getPort(), this::startError);
    }

    private void websocketHandle(ServerWebSocket socket) {
        String path = socket.path();
        if (!StringUtils.startsWith((CharSequence)path, (CharSequence)this.properties.getApiUrl())) {
            log.info("Websocket \u8bf7\u6c42\u5730\u5740 [{}] \u662f\u65e0\u6548\u7684", (Object)path);
            socket.reject();
        } else {
            WebsocketEntity params = this.paramsEntity(socket);
            if (params == null || StringUtils.isBlank((CharSequence)params.getTenantId())) {
                log.error("websocket \u9274\u6743\u5931\u8d25 {}", params == null ? socket.path() : params);
                socket.reject(HttpStatus.UNAUTHORIZED.value());
                return;
            }
            this.createClientConsumer(socket, params);
            socket.textMessageHandler(d -> {
                if ("ping".equals(d)) {
                    socket.writeTextMessage("pong");
                } else {
                    log.info("\u63a5\u6536\u5230\u7684\u6d88\u606f\u4e3a\uff1a{}", d);
                }
            });
        }
        socket.closeHandler(v -> {
            LONG_ADDER.decrement();
            if (log.isDebugEnabled()) {
                log.debug("\u5173\u95ed\u8fde\u63a5\uff0c\u5f53\u524d\u94fe\u63a5\u6570\u91cf\u4e3a\uff1a{}", (Object)LONG_ADDER.longValue());
            }
            log.info("\u5173\u95ed websocket session id: {}", (Object)socket.textHandlerID());
        });
    }

    private void createClientConsumer(ServerWebSocket socket, WebsocketEntity params) {
        String topic = "ws." + params.getType();
        LONG_ADDER.increment();
        if (log.isDebugEnabled()) {
            log.debug("\u521b\u5efa\u8fde\u63a5\uff0c\u5f53\u524d\u94fe\u63a5\u6570\u91cf\u4e3a\uff1a{}", (Object)LONG_ADDER.longValue());
        }
        this.socketConsumer.consume(topic, t -> {
            List<String> userList;
            log.info("\u6d88\u8d39\u8005 {}\u6267\u884c, {}", (Object)topic, t);
            if (t != null && StringUtils.equals((CharSequence)params.getTenantId(), (CharSequence)t.getTenantId()) && (CollectionUtils.isEmpty(userList = t.getUuidList()) || CollectionUtils.containsAny(userList, (Object[])new String[]{params.getUuid()}))) {
                socket.writeTextMessage(JsonUtil.toJson((Object)t.getData()));
            }
        });
    }

    public void stop() throws Exception {
        if (null != this.httpServer) {
            this.httpServer.close(this::stopError);
        }
        super.stop();
    }

    private void startError(AsyncResult<?> result) {
        this.logError(false, result);
    }

    private void stopError(AsyncResult<?> result) {
        this.logError(true, result);
    }

    private void logError(boolean stop, AsyncResult<?> result) {
        String name;
        String string = name = stop ? "\u5173\u95ed" : "\u542f\u52a8";
        if (result.succeeded()) {
            log.info("websocket \u670d\u52a1{}\u6210\u529f\uff0c\u7aef\u53e3\u4e3a: {}", (Object)name, (Object)this.properties.getPort());
        } else {
            log.error("websocket \u670d\u52a1 \u5931\u8d25 ", result.cause());
            log.error("websocket \u670d\u52a1{}\u5931\u8d25\uff0c{}", (Object)name, (Object)result.cause().getMessage());
        }
    }

    private WebsocketEntity paramsEntity(ServerWebSocket socket) {
        WebsocketEntity entity = (WebsocketEntity)PojoUtil.paramsBean((String)socket.query(), WebsocketEntity.class);
        if (entity != null && this.qualified(entity)) {
            LoginUserVo user;
            String userId;
            String token = null;
            String tenantId = null;
            MultiMap map = socket.headers();
            String protocol = map.get((CharSequence)HttpHeaderNames.SEC_WEBSOCKET_PROTOCOL);
            List protocolList = PojoUtil.singleToList((String)protocol);
            if (CollectionUtils.isNotEmpty((Collection)protocolList)) {
                token = (String)protocolList.get(0);
            }
            if (StringUtils.contains(token, (CharSequence)" ")) {
                token = StringUtils.substringAfter((String)token.trim(), (String)" ");
            }
            if (StringUtils.isNotBlank((CharSequence)token) && StringUtils.equals((CharSequence)(userId = this.frameworkAuthService.loginIdByToken(token)), (CharSequence)entity.getUid()) && (user = UserUtil.user((String)token, (String)userId)) != null) {
                tenantId = user.getTenantId();
            }
            entity.setToken(token);
            entity.setTenantId(tenantId);
        }
        return entity;
    }

    private boolean qualified(WebsocketEntity entity) {
        if (entity.qualified()) {
            String code = entity.getType();
            if (this.enumClasses == null) {
                this.enumClasses = PojoUtil.subClasses(WsBaseEnum.class, (String)"cn.sinozg.applet");
            }
            for (Class<WsBaseEnum> enumClass : this.enumClasses) {
                for (WsBaseEnum e : enumClass.getEnumConstants()) {
                    if (!e.code().equals(code)) continue;
                    return true;
                }
            }
        }
        return false;
    }
}

