/*
 * Decompiled with CFR 0.152.
 */
package cn.sinozg.applet.ws.handler;

import cn.sinozg.applet.common.exception.CavException;
import cn.sinozg.applet.common.holder.UserContextHolder;
import cn.sinozg.applet.common.utils.PojoUtil;
import cn.sinozg.applet.common.utils.TirsciUtil;
import cn.sinozg.applet.common.utils.UserUtil;
import cn.sinozg.applet.mq.joint.BaseTopicType;
import cn.sinozg.applet.mq.mq.MqProducer;
import cn.sinozg.applet.ws.comnon.WsTopicType;
import cn.sinozg.applet.ws.joint.WsBaseEnum;
import cn.sinozg.applet.ws.model.WebSocketData;
import jakarta.annotation.Resource;
import java.util.ArrayList;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class WebsocketPublish {
    @Resource
    private MqProducer<WebSocketData> socketProducer;
    private static final Logger log = LoggerFactory.getLogger(WebsocketPublish.class);

    public <E extends Enum<E>, T> void pushAll(E type, T data) {
        this.pushCommon(type, data, new String[0]);
    }

    public <E extends Enum<E>, T> void push(E type, T data, String uid) {
        this.pushCommon(type, data, uid);
    }

    public <E extends Enum<E>, T> void push(E type, T data, String ... uid) {
        this.pushCommon(type, data, uid);
    }

    public void pushData(WebSocketData data) {
        this.push(data);
    }

    private <E extends Enum<E>, T> void pushCommon(E type, T data, String ... uid) {
        WebSocketData params = new WebSocketData();
        if (ArrayUtils.isEmpty((Object[])uid)) {
            log.info("\u63a8\u9001\u7ed9\u6240\u6709\u4eba\uff01");
        } else {
            params.setUuidList(PojoUtil.arrayToList((Object[])uid));
        }
        params.setData(data);
        ArrayList<String> list = new ArrayList<String>();
        if (type != null) {
            list.add(((WsBaseEnum)((Object)type)).code());
        }
        params.setTypes(list);
        this.push(params);
    }

    private void push(WebSocketData params) {
        if (params == null) {
            throw new CavException("BIZ000100054");
        }
        if (params.getData() == null) {
            throw new CavException("BIZ000100055");
        }
        if (CollectionUtils.isEmpty(params.getTypes())) {
            throw new CavException("BIZ000100056");
        }
        if (StringUtils.isBlank((CharSequence)params.getTenantId())) {
            String tenantId = (String)TirsciUtil.tryCatch(UserUtil::tenantId);
            if (StringUtils.isBlank((CharSequence)tenantId)) {
                tenantId = UserContextHolder.getTenantId();
            }
            params.setTenantId(tenantId);
        }
        this.socketProducer.publish((BaseTopicType)WsTopicType.WEB_SOCKET, (Object)params);
    }
}

