/*
 * Decompiled with CFR 0.152.
 */
package cn.sixlab.engine.tpl;

import cn.sixlab.engine.tpl.TemplateEngine;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.scene.control.TextArea;
import javafx.stage.FileChooser;
import javax.script.ScriptException;

public class EngineController {
    @FXML
    private TextArea resultText;
    @FXML
    private TextArea tplText;
    @FXML
    private TextArea dataText;

    private File chooseFile() {
        FileChooser fc = new FileChooser();
        fc.setTitle("\u9009\u62e9\u6587\u4ef6");
        return fc.showOpenDialog(this.dataText.getScene().getWindow());
    }

    public void chooseData(ActionEvent event) {
        File file = this.chooseFile();
        try {
            String data = TemplateEngine.readTextFile(new FileInputStream(file));
            this.dataText.setText(data);
        }
        catch (IOException e) {
            this.dataText.setText("\u83b7\u53d6\u5931\u8d25");
        }
    }

    public void chooseTpl(ActionEvent event) {
        File file = this.chooseFile();
        try {
            String tpl = TemplateEngine.readTextFile(new FileInputStream(file));
            this.tplText.setText(tpl);
        }
        catch (IOException e) {
            this.tplText.setText("\u83b7\u53d6\u5931\u8d25");
        }
    }

    public void saveFile(ActionEvent event) {
        FileChooser fileChooser = new FileChooser();
        FileChooser.ExtensionFilter extFilter = new FileChooser.ExtensionFilter("All types (*.*)", new String[]{"*.*"});
        fileChooser.getExtensionFilters().add((Object)extFilter);
        File file = fileChooser.showSaveDialog(this.dataText.getScene().getWindow());
        if (file == null) {
            return;
        }
        if (!file.exists()) {
            try {
                file.createNewFile();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        String result = this.resultText.getText();
        try {
            FileWriter writer = new FileWriter(file);
            writer.write(result);
            writer.flush();
            writer.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void resetResult(ActionEvent event) {
        this.resultText.setText("");
    }

    public void resetData(ActionEvent event) {
        this.dataText.setText("");
    }

    public void resetTpl(ActionEvent event) {
        this.tplText.setText("");
    }

    public void genText(ActionEvent event) {
        String tpl = this.tplText.getText();
        String data = this.dataText.getText();
        try {
            String result = TemplateEngine.generateFromString(tpl, data);
            this.resultText.setText(result);
        }
        catch (IOException e) {
            this.resultText.setText("\u7a0b\u5e8f\u5185\u90e8\u8bfb\u53d6\u6587\u4ef6\u9519\u8bef\u3002");
        }
        catch (ScriptException e) {
            this.resultText.setText("\u6a21\u677f \u6216\u8005 \u6570\u636e \u9519\u8bef\u3002");
        }
    }
}

