/*
 * Decompiled with CFR 0.152.
 */
package cn.skcks.docking.gb28181.core.sip.dto;

import gov.nist.javax.sip.message.SIPResponse;

public class SipTransactionInfo {
    private String callId;
    private String fromTag;
    private String toTag;
    private String viaBranch;
    private String ssrc;

    public SipTransactionInfo(SIPResponse response) {
        this.callId = response.getCallIdHeader().getCallId();
        this.fromTag = response.getFromTag();
        this.toTag = response.getToTag();
        this.viaBranch = response.getTopmostViaHeader().getBranch();
    }

    public SipTransactionInfo(SIPResponse response, String ssrc) {
        this(response);
        this.ssrc = ssrc;
    }

    public SipTransactionInfo() {
    }

    public String getCallId() {
        return this.callId;
    }

    public String getFromTag() {
        return this.fromTag;
    }

    public String getToTag() {
        return this.toTag;
    }

    public String getViaBranch() {
        return this.viaBranch;
    }

    public String getSsrc() {
        return this.ssrc;
    }

    public void setCallId(String callId) {
        this.callId = callId;
    }

    public void setFromTag(String fromTag) {
        this.fromTag = fromTag;
    }

    public void setToTag(String toTag) {
        this.toTag = toTag;
    }

    public void setViaBranch(String viaBranch) {
        this.viaBranch = viaBranch;
    }

    public void setSsrc(String ssrc) {
        this.ssrc = ssrc;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SipTransactionInfo)) {
            return false;
        }
        SipTransactionInfo other = (SipTransactionInfo)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$callId = this.getCallId();
        String other$callId = other.getCallId();
        if (this$callId == null ? other$callId != null : !this$callId.equals(other$callId)) {
            return false;
        }
        String this$fromTag = this.getFromTag();
        String other$fromTag = other.getFromTag();
        if (this$fromTag == null ? other$fromTag != null : !this$fromTag.equals(other$fromTag)) {
            return false;
        }
        String this$toTag = this.getToTag();
        String other$toTag = other.getToTag();
        if (this$toTag == null ? other$toTag != null : !this$toTag.equals(other$toTag)) {
            return false;
        }
        String this$viaBranch = this.getViaBranch();
        String other$viaBranch = other.getViaBranch();
        if (this$viaBranch == null ? other$viaBranch != null : !this$viaBranch.equals(other$viaBranch)) {
            return false;
        }
        String this$ssrc = this.getSsrc();
        String other$ssrc = other.getSsrc();
        return !(this$ssrc == null ? other$ssrc != null : !this$ssrc.equals(other$ssrc));
    }

    protected boolean canEqual(Object other) {
        return other instanceof SipTransactionInfo;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $callId = this.getCallId();
        result = result * 59 + ($callId == null ? 43 : $callId.hashCode());
        String $fromTag = this.getFromTag();
        result = result * 59 + ($fromTag == null ? 43 : $fromTag.hashCode());
        String $toTag = this.getToTag();
        result = result * 59 + ($toTag == null ? 43 : $toTag.hashCode());
        String $viaBranch = this.getViaBranch();
        result = result * 59 + ($viaBranch == null ? 43 : $viaBranch.hashCode());
        String $ssrc = this.getSsrc();
        result = result * 59 + ($ssrc == null ? 43 : $ssrc.hashCode());
        return result;
    }

    public String toString() {
        return "SipTransactionInfo(callId=" + this.getCallId() + ", fromTag=" + this.getFromTag() + ", toTag=" + this.getToTag() + ", viaBranch=" + this.getViaBranch() + ", ssrc=" + this.getSsrc() + ")";
    }
}

