/*
 * Decompiled with CFR 0.152.
 */
package cn.skcks.docking.gb28181.core.sip.executor;

import java.util.concurrent.Executor;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadPoolExecutor;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.annotation.Order;
import org.springframework.scheduling.annotation.EnableAsync;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;

@Configuration
@Order(value=1)
@EnableAsync(proxyTargetClass=true)
public class DefaultSipExecutor {
    public static final int CPU_NUM = Runtime.getRuntime().availableProcessors();
    public static final int MAX_POOL_SIZE = CPU_NUM * 2;
    private static final int KEEP_ALIVE_TIME = 30;
    public static final int TASK_NUM = 10000;
    public static final String THREAD_NAME_PREFIX = "sip-executor";
    public static final String EXECUTOR_BEAN_NAME = "sipTaskExecutor";

    @Bean(value={"sipTaskExecutor"})
    public Executor sipTaskExecutor() {
        ThreadPoolTaskExecutor executor = new ThreadPoolTaskExecutor();
        executor.setCorePoolSize(CPU_NUM);
        executor.setMaxPoolSize(MAX_POOL_SIZE);
        executor.setQueueCapacity(10000);
        executor.setKeepAliveSeconds(30);
        executor.setThreadNamePrefix(THREAD_NAME_PREFIX);
        executor.setRejectedExecutionHandler((RejectedExecutionHandler)new ThreadPoolExecutor.CallerRunsPolicy());
        executor.initialize();
        return executor;
    }
}

