/*
 * Decompiled with CFR 0.152.
 */
package cn.skcks.docking.gb28181.core.sip.listener;

import cn.skcks.docking.gb28181.core.sip.listener.SipListener;
import cn.skcks.docking.gb28181.core.sip.message.processor.MessageProcessor;
import cn.skcks.docking.gb28181.core.sip.message.subscribe.GenericSubscribe;
import cn.skcks.docking.gb28181.core.sip.message.subscribe.SipSubscribe;
import gov.nist.javax.sip.message.SIPResponse;
import java.util.EventObject;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.sip.ClientTransaction;
import javax.sip.DialogTerminatedEvent;
import javax.sip.IOExceptionEvent;
import javax.sip.RequestEvent;
import javax.sip.ResponseEvent;
import javax.sip.TimeoutEvent;
import javax.sip.TransactionTerminatedEvent;
import javax.sip.header.CSeqHeader;
import javax.sip.header.CallIdHeader;
import javax.sip.message.Request;
import javax.sip.message.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Component;

@Component
public class SipListenerImpl
implements SipListener {
    private static final Logger log = LoggerFactory.getLogger(SipListenerImpl.class);
    private final SipSubscribe subscribe;
    private final ConcurrentMap<String, MessageProcessor> requestProcessor = new ConcurrentHashMap<String, MessageProcessor>();
    private final ConcurrentMap<String, MessageProcessor> responseProcessor = new ConcurrentHashMap<String, MessageProcessor>();

    @Override
    public void addRequestProcessor(String method, MessageProcessor messageProcessor) {
        log.debug("[SipListener] \u6ce8\u518c {} \u8bf7\u6c42\u5904\u7406\u5668", (Object)method);
        this.requestProcessor.put(method, messageProcessor);
    }

    @Override
    public void addResponseProcessor(String method, MessageProcessor messageProcessor) {
        log.debug("[SipListener] \u6ce8\u518c {} \u54cd\u5e94\u5904\u7406\u5668", (Object)method);
        this.responseProcessor.put(method, messageProcessor);
    }

    @Async(value="sipTaskExecutor")
    public void processRequest(RequestEvent requestEvent) {
        String method = requestEvent.getRequest().getMethod();
        log.debug("\u4f20\u5165\u8bf7\u6c42 method => {}", (Object)method);
        Optional.ofNullable((MessageProcessor)this.requestProcessor.get(method)).ifPresent(processor -> processor.process((EventObject)requestEvent));
    }

    @Async(value="sipTaskExecutor")
    public void processResponse(ResponseEvent responseEvent) {
        Response response = responseEvent.getResponse();
        int status = response.getStatusCode();
        CSeqHeader cseqHeader = (CSeqHeader)response.getHeader("CSeq");
        String method = cseqHeader.getMethod();
        log.debug("{} {}", (Object)method, (Object)response);
        if (status >= 200 && status < 300 || status == 401) {
            log.debug("\u4f20\u5165\u54cd\u5e94 method => {}", (Object)method);
            Optional.ofNullable((MessageProcessor)this.responseProcessor.get(method)).ifPresent(processor -> processor.process((EventObject)responseEvent));
        } else if (status < 100 || status >= 200) {
            log.warn("\u63a5\u6536\u5230\u5931\u8d25\u7684response\u54cd\u5e94\uff01status\uff1a" + status + ",message:" + response.getReasonPhrase());
            SIPResponse sipResponse = (SIPResponse)response;
            String callId = sipResponse.getCallIdHeader().getCallId();
            Optional.ofNullable(this.subscribe.getSipResponseSubscribe().getPublisher(GenericSubscribe.Helper.getKey("INVITE", callId))).ifPresent(publisher -> publisher.submit(sipResponse));
            if (responseEvent.getDialog() != null) {
                responseEvent.getDialog().delete();
            }
        }
    }

    public void processTimeout(TimeoutEvent timeoutEvent) {
        CallIdHeader callIdHeader;
        Request request;
        ClientTransaction clientTransaction = timeoutEvent.getClientTransaction();
        if (clientTransaction != null && (request = clientTransaction.getRequest()) != null && (callIdHeader = (CallIdHeader)request.getHeader("Call-ID")) != null) {
            log.debug("\u4f1a\u8bdd\u8d85\u65f6 callId => {}", (Object)callIdHeader.getCallId());
        }
    }

    public void processIOException(IOExceptionEvent exceptionEvent) {
    }

    public void processTransactionTerminated(TransactionTerminatedEvent transactionTerminatedEvent) {
    }

    public void processDialogTerminated(DialogTerminatedEvent dialogTerminatedEvent) {
        CallIdHeader callIdHeader = dialogTerminatedEvent.getDialog().getCallId();
        log.debug("\u4f1a\u8bdd\u7ec8\u6b62 callId => {}", (Object)callIdHeader.getCallId());
    }

    public SipListenerImpl(SipSubscribe subscribe) {
        this.subscribe = subscribe;
    }
}

