/*
 * Decompiled with CFR 0.152.
 */
package cn.skcks.docking.gb28181.core.sip.logger;

import gov.nist.core.CommonLogger;
import gov.nist.core.ServerLogger;
import gov.nist.core.StackLogger;
import gov.nist.javax.sip.message.SIPMessage;
import gov.nist.javax.sip.stack.SIPTransactionStack;
import java.util.Properties;
import javax.sip.SipStack;

public class ServerLoggerImpl
implements ServerLogger {
    private boolean showLog = true;
    protected StackLogger stackLogger;

    public void closeLogFile() {
    }

    public void logMessage(SIPMessage message, String from, String to, boolean sender, long time) {
        if (!this.showLog) {
            return;
        }
        String log = (sender ? "\u53d1\u9001: \u76ee\u6807 => " + to : "\u63a5\u6536: \u6765\u81ea => " + from) + "\r\n" + message;
        this.stackLogger.logInfo(log);
    }

    public void logMessage(SIPMessage message, String from, String to, String status, boolean sender, long time) {
        if (!this.showLog) {
            return;
        }
        String log = (sender ? "\u53d1\u9001: \u76ee\u6807 => " + to : "\u63a5\u6536: \u6765\u81ea => " + from) + "\r\n" + message;
        this.stackLogger.logInfo(log);
    }

    public void logMessage(SIPMessage message, String from, String to, String status, boolean sender) {
        if (!this.showLog) {
            return;
        }
        String log = (sender ? "\u53d1\u9001: \u76ee\u6807 => " + to : "\u63a5\u6536: \u6765\u81ea => " + from) + "\r\n" + message;
        this.stackLogger.logInfo(log);
    }

    public void logException(Exception ex) {
        if (!this.showLog) {
            return;
        }
        this.stackLogger.logException((Throwable)ex);
    }

    public void setStackProperties(Properties stackProperties) {
        if (!this.showLog) {
            return;
        }
        String TRACE_LEVEL = stackProperties.getProperty("gov.nist.javax.sip.TRACE_LEVEL");
        if (TRACE_LEVEL != null) {
            this.showLog = true;
        }
    }

    public void setSipStack(SipStack sipStack) {
        if (!this.showLog) {
            return;
        }
        if (sipStack instanceof SIPTransactionStack) {
            SIPTransactionStack st = (SIPTransactionStack)sipStack;
            this.stackLogger = CommonLogger.getLogger(st.getClass());
        }
    }
}

