/*
 * Decompiled with CFR 0.152.
 */
package cn.skcks.docking.gb28181.core.sip.message.auth;

import gov.nist.core.InternalErrorHandler;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.time.Instant;
import java.util.Random;
import javax.sip.address.URI;
import javax.sip.header.AuthorizationHeader;
import javax.sip.header.Header;
import javax.sip.header.HeaderFactory;
import javax.sip.header.WWWAuthenticateHeader;
import javax.sip.message.Request;
import javax.sip.message.Response;
import org.apache.commons.lang3.ObjectUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DigestServerAuthenticationHelper {
    private static final Logger log = LoggerFactory.getLogger(DigestServerAuthenticationHelper.class);
    private static final MessageDigest messageDigest;
    public static final String DEFAULT_ALGORITHM = "MD5";
    public static final String DEFAULT_SCHEME = "Digest";
    private static final char[] toHex;

    public static String toHexString(byte[] b) {
        int pos = 0;
        char[] c = new char[b.length * 2];
        for (int i = 0; i < b.length; ++i) {
            c[pos++] = toHex[b[i] >> 4 & 0xF];
            c[pos++] = toHex[b[i] & 0xF];
        }
        return new String(c);
    }

    private static String generateNonce() {
        long time = Instant.now().toEpochMilli();
        Random rand = new Random();
        long pad = rand.nextLong();
        String nonceString = Long.valueOf(time).toString() + Long.valueOf(pad).toString();
        byte[] mdBytes = messageDigest.digest(nonceString.getBytes());
        return DigestServerAuthenticationHelper.toHexString(mdBytes);
    }

    public static void generateChallenge(HeaderFactory headerFactory, Response response, String realm) {
        try {
            WWWAuthenticateHeader proxyAuthenticate = headerFactory.createWWWAuthenticateHeader(DEFAULT_SCHEME);
            proxyAuthenticate.setParameter("realm", realm);
            proxyAuthenticate.setParameter("qop", "auth");
            proxyAuthenticate.setParameter("nonce", DigestServerAuthenticationHelper.generateNonce());
            proxyAuthenticate.setParameter("algorithm", DEFAULT_ALGORITHM);
            response.setHeader((Header)proxyAuthenticate);
        }
        catch (Exception ex) {
            InternalErrorHandler.handleException((Exception)ex);
        }
    }

    public static boolean doAuthenticateHashedPassword(Request request, String hashedPassword) {
        AuthorizationHeader authHeader = (AuthorizationHeader)request.getHeader("Authorization");
        if (authHeader == null) {
            return false;
        }
        String realm = authHeader.getRealm();
        String username = authHeader.getUsername();
        if (username == null || realm == null) {
            return false;
        }
        String nonce = authHeader.getNonce();
        URI uri = authHeader.getURI();
        if (uri == null) {
            return false;
        }
        String A2 = request.getMethod().toUpperCase() + ":" + uri;
        String HA1 = hashedPassword;
        byte[] mdbytes = messageDigest.digest(A2.getBytes());
        String HA2 = DigestServerAuthenticationHelper.toHexString(mdbytes);
        String cnonce = authHeader.getCNonce();
        String KD = HA1 + ":" + nonce;
        if (cnonce != null) {
            KD = KD + ":" + cnonce;
        }
        KD = KD + ":" + HA2;
        mdbytes = messageDigest.digest(KD.getBytes());
        String mdString = DigestServerAuthenticationHelper.toHexString(mdbytes);
        String response = authHeader.getResponse();
        return mdString.equals(response);
    }

    public static boolean doAuthenticatePlainTextPassword(Request request, String pass) {
        AuthorizationHeader authHeader = (AuthorizationHeader)request.getHeader("Authorization");
        if (authHeader == null || authHeader.getRealm() == null) {
            return false;
        }
        String realm = authHeader.getRealm().trim();
        String username = authHeader.getUsername().trim();
        if (ObjectUtils.anyNull((Object[])new Object[]{username, realm})) {
            return false;
        }
        String nonce = authHeader.getNonce();
        URI uri = authHeader.getURI();
        if (uri == null) {
            return false;
        }
        String qop = authHeader.getQop();
        String cnonce = authHeader.getCNonce();
        int nc = authHeader.getNonceCount();
        String ncStr = String.format("%08x", nc).toUpperCase();
        String A1 = String.join((CharSequence)":", username, realm, pass);
        String A2 = String.join((CharSequence)":", request.getMethod().toUpperCase(), uri.toString());
        byte[] mdbytes = messageDigest.digest(A1.getBytes());
        String HA1 = DigestServerAuthenticationHelper.toHexString(mdbytes);
        log.debug("A1: " + A1);
        log.debug("A2: " + A2);
        mdbytes = messageDigest.digest(A2.getBytes());
        String HA2 = DigestServerAuthenticationHelper.toHexString(mdbytes);
        log.debug("HA1: " + HA1);
        log.debug("HA2: " + HA2);
        log.debug("nonce: " + nonce);
        log.debug("nc: " + ncStr);
        log.debug("cnonce: " + cnonce);
        log.debug("qop: " + qop);
        String KD = HA1 + ":" + nonce;
        if (qop != null && qop.equalsIgnoreCase("auth")) {
            if (nc != -1) {
                KD = KD + ":" + ncStr;
            }
            if (cnonce != null) {
                KD = KD + ":" + cnonce;
            }
            KD = KD + ":" + qop;
        }
        KD = KD + ":" + HA2;
        log.debug("KD: " + KD);
        mdbytes = messageDigest.digest(KD.getBytes());
        String mdString = DigestServerAuthenticationHelper.toHexString(mdbytes);
        log.debug("mdString: " + mdString);
        String response = authHeader.getResponse();
        log.debug("response: " + response);
        return mdString.equals(response);
    }

    static {
        toHex = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
        try {
            messageDigest = MessageDigest.getInstance(DEFAULT_ALGORITHM);
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
    }
}

