/*
 * Decompiled with CFR 0.152.
 */
package cn.skcks.docking.gb28181.core.sip.message.parser;

import gov.nist.core.Host;
import gov.nist.core.HostNameParser;
import gov.nist.core.LexerCore;
import gov.nist.javax.sip.address.AddressImpl;
import gov.nist.javax.sip.address.GenericURI;
import gov.nist.javax.sip.address.SipUri;
import gov.nist.javax.sip.address.TelephoneNumber;
import gov.nist.javax.sip.header.ExtensionHeaderImpl;
import gov.nist.javax.sip.header.NameMap;
import gov.nist.javax.sip.header.RequestLine;
import gov.nist.javax.sip.header.SIPHeader;
import gov.nist.javax.sip.header.StatusLine;
import gov.nist.javax.sip.message.SIPMessage;
import gov.nist.javax.sip.message.SIPRequest;
import gov.nist.javax.sip.message.SIPResponse;
import gov.nist.javax.sip.parser.AddressParser;
import gov.nist.javax.sip.parser.HeaderParser;
import gov.nist.javax.sip.parser.Lexer;
import gov.nist.javax.sip.parser.MessageParser;
import gov.nist.javax.sip.parser.ParseExceptionListener;
import gov.nist.javax.sip.parser.ParserFactory;
import gov.nist.javax.sip.parser.RequestLineParser;
import gov.nist.javax.sip.parser.StatusLineParser;
import gov.nist.javax.sip.parser.URLParser;
import java.nio.charset.StandardCharsets;
import java.text.ParseException;

public class GBStringMsgParser
implements MessageParser {
    protected static boolean computeContentLengthFromMessage = false;

    public SIPMessage parseSIPMessage(byte[] msgBuffer, boolean readBody, boolean strict, ParseExceptionListener parseExceptionListener) throws ParseException {
        if (msgBuffer == null || msgBuffer.length == 0) {
            return null;
        }
        int i = 0;
        try {
            while (msgBuffer[i] < 32) {
                ++i;
            }
        }
        catch (ArrayIndexOutOfBoundsException e) {
            return null;
        }
        String currentLine = null;
        Object currentHeader = null;
        boolean isFirstLine = true;
        SIPMessage message = null;
        do {
            int lineStart = i;
            try {
                while (msgBuffer[i] != 13 && msgBuffer[i] != 10) {
                    ++i;
                }
            }
            catch (ArrayIndexOutOfBoundsException e) {
                break;
            }
            int lineLength = i - lineStart;
            currentLine = new String(msgBuffer, lineStart, lineLength, StandardCharsets.UTF_8);
            if ((currentLine = GBStringMsgParser.trimEndOfLine(currentLine)).length() == 0) {
                if (currentHeader != null && message != null) {
                    this.processHeader((String)currentHeader, message, parseExceptionListener, msgBuffer);
                }
            } else if (isFirstLine) {
                message = this.processFirstLine(currentLine, parseExceptionListener, msgBuffer);
            } else {
                char firstChar = currentLine.charAt(0);
                if (firstChar == '\t' || firstChar == ' ') {
                    if (currentHeader == null) {
                        throw new ParseException("Bad header continuation.", 0);
                    }
                    currentHeader = (String)currentHeader + currentLine.substring(1);
                } else {
                    if (currentHeader != null && message != null) {
                        this.processHeader((String)currentHeader, message, parseExceptionListener, msgBuffer);
                    }
                    currentHeader = currentLine;
                }
            }
            if (msgBuffer[i] == 13 && msgBuffer.length > i + 1 && msgBuffer[i + 1] == 10) {
                ++i;
            }
            ++i;
            isFirstLine = false;
        } while (currentLine.length() > 0);
        if (message == null) {
            throw new ParseException("Bad message", 0);
        }
        message.setSize(i);
        if (readBody && message.getContentLength() != null) {
            String last4Chars;
            if (message.getContentLength().getContentLength() != 0) {
                bodyLength = msgBuffer.length - i;
                byte[] body = new byte[bodyLength];
                System.arraycopy(msgBuffer, i, body, 0, bodyLength);
                message.setMessageContent(body, !strict, computeContentLengthFromMessage, message.getContentLength().getContentLength());
            } else if (message.getCSeqHeader().getMethod().equalsIgnoreCase("MESSAGE")) {
                bodyLength = msgBuffer.length - i;
                byte[] body = new byte[bodyLength];
                System.arraycopy(msgBuffer, i, body, 0, bodyLength);
                message.setMessageContent(body, !strict, computeContentLengthFromMessage, bodyLength);
            } else if (!computeContentLengthFromMessage && strict && !"\r\n\r\n".equals(last4Chars = new String(msgBuffer, msgBuffer.length - 4, 4))) {
                throw new ParseException("Extraneous characters at the end of the message ", i);
            }
        }
        return message;
    }

    protected static String trimEndOfLine(String line) {
        int i;
        if (line == null) {
            return null;
        }
        for (i = line.length() - 1; i >= 0 && line.charAt(i) <= ' '; --i) {
        }
        if (i == line.length() - 1) {
            return line;
        }
        if (i == -1) {
            return "";
        }
        return line.substring(0, i + 1);
    }

    protected SIPMessage processFirstLine(String firstLine, ParseExceptionListener parseExceptionListener, byte[] msgBuffer) throws ParseException {
        SIPRequest message;
        if (!firstLine.startsWith("SIP/2.0")) {
            message = new SIPRequest();
            try {
                RequestLine requestLine = new RequestLineParser(firstLine + "\n").parse();
                message.setRequestLine(requestLine);
            }
            catch (ParseException ex) {
                if (parseExceptionListener != null) {
                    parseExceptionListener.handleException(ex, (SIPMessage)message, RequestLine.class, firstLine, new String(msgBuffer, StandardCharsets.UTF_8));
                }
                throw ex;
            }
        } else {
            message = new SIPResponse();
            try {
                StatusLine sl = new StatusLineParser(firstLine + "\n").parse();
                ((SIPResponse)message).setStatusLine(sl);
            }
            catch (ParseException ex) {
                if (parseExceptionListener != null) {
                    parseExceptionListener.handleException(ex, (SIPMessage)message, StatusLine.class, firstLine, new String(msgBuffer, StandardCharsets.UTF_8));
                }
                throw ex;
            }
        }
        return message;
    }

    protected void processHeader(String header, SIPMessage message, ParseExceptionListener parseExceptionListener, byte[] rawMessage) throws ParseException {
        block7: {
            if (header == null || header.length() == 0) {
                return;
            }
            HeaderParser headerParser = null;
            try {
                headerParser = ParserFactory.createParser((String)(header + "\n"));
            }
            catch (ParseException ex) {
                if (parseExceptionListener != null) {
                    parseExceptionListener.handleException(ex, message, null, header, null);
                    return;
                }
                throw ex;
            }
            try {
                SIPHeader sipHeader = headerParser.parse();
                message.attachHeader(sipHeader, false);
            }
            catch (ParseException ex) {
                if (parseExceptionListener == null) break block7;
                String headerName = Lexer.getHeaderName((String)header);
                Class<ExtensionHeaderImpl> headerClass = NameMap.getClassFromName((String)headerName);
                if (headerClass == null) {
                    headerClass = ExtensionHeaderImpl.class;
                }
                parseExceptionListener.handleException(ex, message, headerClass, header, new String(rawMessage, StandardCharsets.UTF_8));
            }
        }
    }

    public AddressImpl parseAddress(String address) throws ParseException {
        AddressParser addressParser = new AddressParser(address);
        return addressParser.address(true);
    }

    public Host parseHost(String host) throws ParseException {
        Lexer lexer = new Lexer("charLexer", host);
        return new HostNameParser((LexerCore)lexer).host();
    }

    public TelephoneNumber parseTelephoneNumber(String telephone_number) throws ParseException {
        return new URLParser(telephone_number).parseTelephoneNumber(true);
    }

    public SipUri parseSIPUrl(String url) throws ParseException {
        try {
            return new URLParser(url).sipURL(true);
        }
        catch (ClassCastException ex) {
            throw new ParseException(url + " Not a SIP URL ", 0);
        }
    }

    public GenericURI parseUrl(String url) throws ParseException {
        return new URLParser(url).parse();
    }

    public static SIPHeader parseSIPHeader(String header) throws ParseException {
        int i;
        int start = 0;
        int end = header.length() - 1;
        try {
            while (header.charAt(start) <= ' ') {
                ++start;
            }
            while (header.charAt(end) <= ' ') {
                --end;
            }
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new ParseException("Empty header.", 0);
        }
        StringBuilder buffer = new StringBuilder(end + 1);
        int lineStart = start;
        boolean endOfLine = false;
        for (i = start; i <= end; ++i) {
            char c = header.charAt(i);
            if (c == '\r' || c == '\n') {
                if (endOfLine) continue;
                buffer.append(header, lineStart, i);
                endOfLine = true;
                continue;
            }
            if (!endOfLine) continue;
            endOfLine = false;
            if (c == ' ' || c == '\t') {
                buffer.append(' ');
                lineStart = i + 1;
                continue;
            }
            lineStart = i;
        }
        buffer.append(header, lineStart, i);
        buffer.append('\n');
        HeaderParser hp = ParserFactory.createParser((String)buffer.toString());
        if (hp == null) {
            throw new ParseException("could not create parser", 0);
        }
        return hp.parse();
    }

    public RequestLine parseSIPRequestLine(String requestLine) throws ParseException {
        requestLine = (String)requestLine + "\n";
        return new RequestLineParser((String)requestLine).parse();
    }

    public StatusLine parseSIPStatusLine(String statusLine) throws ParseException {
        statusLine = (String)statusLine + "\n";
        return new StatusLineParser((String)statusLine).parse();
    }

    public static void setComputeContentLengthFromMessage(boolean computeContentLengthFromMessage) {
        GBStringMsgParser.computeContentLengthFromMessage = computeContentLengthFromMessage;
    }
}

