/*
 * Decompiled with CFR 0.152.
 */
package cn.skcks.docking.gb28181.core.sip.message.processor.bye.request;

import cn.skcks.docking.gb28181.core.sip.listener.SipListener;
import cn.skcks.docking.gb28181.core.sip.message.processor.MessageProcessor;
import cn.skcks.docking.gb28181.core.sip.message.subscribe.GenericSubscribe;
import cn.skcks.docking.gb28181.core.sip.message.subscribe.SipSubscribe;
import cn.skcks.docking.gb28181.core.sip.service.SipService;
import cn.skcks.docking.gb28181.sip.method.invite.response.InviteResponseBuilder;
import gov.nist.javax.sip.message.SIPRequest;
import jakarta.annotation.PostConstruct;
import java.util.EventObject;
import java.util.Optional;
import javax.sip.RequestEvent;
import javax.sip.SipException;
import javax.sip.SipProvider;
import javax.sip.message.Request;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class ByeRequestProcessor
implements MessageProcessor {
    private static final Logger log = LoggerFactory.getLogger(ByeRequestProcessor.class);
    private final SipListener sipListener;
    private final SipSubscribe subscribe;
    private final SipService sipService;

    @Override
    @PostConstruct
    public void init() {
        this.sipListener.addRequestProcessor("BYE", this);
    }

    @Override
    public void process(EventObject eventObject) {
        RequestEvent requestEvent = (RequestEvent)eventObject;
        SIPRequest request = (SIPRequest)requestEvent.getRequest();
        String callId = request.getCallId().getCallId();
        String key = GenericSubscribe.Helper.getKey("BYE", callId);
        log.info("key {}", (Object)key);
        String ip = request.getLocalAddress().getHostAddress();
        String transport = request.getTopmostViaHeader().getTransport();
        SipProvider provider = this.sipService.getProvider(transport, ip);
        Optional.ofNullable(this.subscribe.getSipRequestSubscribe().getPublisher(key)).ifPresentOrElse(publisher -> publisher.submit(request), () -> {
            try {
                provider.sendResponse(InviteResponseBuilder.builder().build().createTryingInviteResponse((Request)request));
            }
            catch (SipException e) {
                throw new RuntimeException(e);
            }
        });
    }

    public ByeRequestProcessor(SipListener sipListener, SipSubscribe subscribe, SipService sipService) {
        this.sipListener = sipListener;
        this.subscribe = subscribe;
        this.sipService = sipService;
    }
}

