/*
 * Decompiled with CFR 0.152.
 */
package cn.skcks.docking.gb28181.core.sip.message.processor.message.request;

import cn.skcks.docking.gb28181.common.json.ResponseStatus;
import cn.skcks.docking.gb28181.common.xml.XmlUtils;
import cn.skcks.docking.gb28181.config.sip.SipConfig;
import cn.skcks.docking.gb28181.core.sip.listener.SipListener;
import cn.skcks.docking.gb28181.core.sip.message.processor.MessageProcessor;
import cn.skcks.docking.gb28181.core.sip.message.sender.SipMessageSender;
import cn.skcks.docking.gb28181.core.sip.message.subscribe.GenericSubscribe;
import cn.skcks.docking.gb28181.core.sip.message.subscribe.SipSubscribe;
import cn.skcks.docking.gb28181.core.sip.utils.SipUtil;
import cn.skcks.docking.gb28181.orm.mybatis.dynamic.model.DockingDevice;
import cn.skcks.docking.gb28181.service.docking.device.DockingDeviceService;
import cn.skcks.docking.gb28181.service.notify.MediaStatusService;
import cn.skcks.docking.gb28181.sip.manscdp.MessageDTO;
import cn.skcks.docking.gb28181.sip.manscdp.catalog.response.CatalogResponseDTO;
import cn.skcks.docking.gb28181.sip.manscdp.mediastatus.notify.MediaStatusRequestDTO;
import cn.skcks.docking.gb28181.sip.manscdp.recordinfo.response.RecordInfoResponseDTO;
import cn.skcks.docking.gb28181.sip.utils.MANSCDPUtils;
import gov.nist.javax.sip.message.SIPRequest;
import gov.nist.javax.sip.message.SIPResponse;
import jakarta.annotation.PostConstruct;
import java.util.EventObject;
import java.util.Optional;
import javax.sip.RequestEvent;
import javax.sip.message.Message;
import javax.sip.message.Request;
import javax.sip.message.Response;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class MessageRequestProcessor
implements MessageProcessor {
    private static final Logger log = LoggerFactory.getLogger(MessageRequestProcessor.class);
    private final SipListener sipListener;
    private final DockingDeviceService deviceService;
    private final SipMessageSender sender;
    private final SipSubscribe subscribe;
    private final SipConfig sipConfig;
    private final MediaStatusService mediaStatusService;

    @Override
    @PostConstruct
    public void init() {
        this.sipListener.addRequestProcessor("MESSAGE", this);
    }

    @Override
    public void process(EventObject eventObject) {
        Response response;
        RequestEvent requestEvent = (RequestEvent)eventObject;
        SIPRequest request = (SIPRequest)requestEvent.getRequest();
        String deviceId = SipUtil.getUserIdFromFromHeader((Request)request);
        String callId = request.getCallIdHeader().getCallId();
        byte[] content = request.getRawContent();
        MessageDTO messageDto = (MessageDTO)MANSCDPUtils.parse((byte[])content, MessageDTO.class);
        log.debug("\u63a5\u6536\u5230\u7684\u6d88\u606f => {}", (Object)messageDto);
        DockingDevice device = this.deviceService.getDevice(deviceId);
        String senderIp = request.getLocalAddress().getHostAddress();
        if (device == null) {
            log.info("\u672a\u627e\u5230\u76f8\u5173\u8bbe\u5907\u4fe1\u606f => {}", (Object)deviceId);
            Response response2 = this.response(request, 404, "\u8bbe\u5907\u672a\u6ce8\u518c");
            this.sender.send(senderIp, (Message)response2);
            return;
        }
        Response ok = this.response(request, 200, "OK");
        if (messageDto.getCmdType().equalsIgnoreCase("Keepalive")) {
            response = ok;
            this.deviceService.online(device, response);
        } else if (messageDto.getCmdType().equalsIgnoreCase("RecordInfo")) {
            response = ok;
            RecordInfoResponseDTO dto = (RecordInfoResponseDTO)XmlUtils.parse((byte[])content, RecordInfoResponseDTO.class, (String)"GB2312");
            String key = GenericSubscribe.Helper.getKey("RecordInfo", dto.getDeviceId(), dto.getSn());
            Optional.ofNullable(this.subscribe.getSipRequestSubscribe().getPublisher(key)).ifPresentOrElse(publisher -> publisher.submit(request), () -> log.warn("\u5bf9\u5e94\u8ba2\u9605 {} \u5df2\u7ed3\u675f, \u5f02\u5e38\u6570\u636e => {}", (Object)key, (Object)dto));
        } else if (messageDto.getCmdType().equalsIgnoreCase("Catalog")) {
            CatalogResponseDTO catalogResponseDTO = (CatalogResponseDTO)MANSCDPUtils.parse((byte[])content, CatalogResponseDTO.class);
            String key = GenericSubscribe.Helper.getKey("Catalog", catalogResponseDTO.getDeviceId(), catalogResponseDTO.getSn());
            Optional.ofNullable(this.subscribe.getSipRequestSubscribe().getPublisher(key)).ifPresent(publisher -> publisher.submit(request));
            response = ok;
        } else if (messageDto.getCmdType().equalsIgnoreCase("MediaStatus")) {
            response = ok;
            this.sender.send(senderIp, (Message)response);
            MediaStatusRequestDTO mediaStatusRequestDTO = (MediaStatusRequestDTO)MANSCDPUtils.parse((byte[])content, MediaStatusRequestDTO.class);
            if (StringUtils.equalsIgnoreCase((CharSequence)mediaStatusRequestDTO.getNotifyType(), (CharSequence)"121")) {
                this.mediaStatusService.process(request, mediaStatusRequestDTO);
                return;
            }
        } else {
            response = this.response(request, 501, ResponseStatus.NOT_IMPLEMENTED.getMessage());
        }
        this.sender.send(senderIp, (Message)response);
    }

    public Response response(SIPRequest request, int status, String message) {
        if (request.getToHeader().getTag() == null) {
            request.getToHeader().setTag(SipUtil.generateTag());
        }
        SIPResponse response = (SIPResponse)this.getMessageFactory().createResponse(status, (Request)request);
        if (message != null) {
            response.setReasonPhrase(message);
        }
        return response;
    }

    public MessageRequestProcessor(SipListener sipListener, DockingDeviceService deviceService, SipMessageSender sender, SipSubscribe subscribe, SipConfig sipConfig, MediaStatusService mediaStatusService) {
        this.sipListener = sipListener;
        this.deviceService = deviceService;
        this.sender = sender;
        this.subscribe = subscribe;
        this.sipConfig = sipConfig;
        this.mediaStatusService = mediaStatusService;
    }
}

