/*
 * Decompiled with CFR 0.152.
 */
package cn.skcks.docking.gb28181.core.sip.message.processor.message.response;

import cn.skcks.docking.gb28181.core.sip.listener.SipListener;
import cn.skcks.docking.gb28181.core.sip.message.processor.MessageProcessor;
import cn.skcks.docking.gb28181.core.sip.message.request.SipRequestBuilder;
import cn.skcks.docking.gb28181.core.sip.message.sender.SipMessageSender;
import cn.skcks.docking.gb28181.core.sip.message.subscribe.GenericSubscribe;
import cn.skcks.docking.gb28181.core.sip.message.subscribe.SipSubscribe;
import cn.skcks.docking.gb28181.sdp.GB28181Description;
import cn.skcks.docking.gb28181.sdp.parser.GB28181DescriptionParser;
import gov.nist.javax.sip.ResponseEventExt;
import gov.nist.javax.sip.message.SIPResponse;
import jakarta.annotation.PostConstruct;
import java.text.ParseException;
import java.util.EventObject;
import java.util.Optional;
import javax.sdp.SdpParseException;
import javax.sip.InvalidArgumentException;
import javax.sip.ResponseEvent;
import javax.sip.SipException;
import javax.sip.SipFactory;
import javax.sip.address.SipURI;
import javax.sip.header.CallIdHeader;
import javax.sip.message.Message;
import javax.sip.message.Request;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class InviteResponseProcessor
implements MessageProcessor {
    private static final Logger log = LoggerFactory.getLogger(InviteResponseProcessor.class);
    private final SipListener sipListener;
    private final SipMessageSender sender;
    private final SipSubscribe subscribe;

    @Override
    @PostConstruct
    public void init() {
        this.sipListener.addResponseProcessor("INVITE", this);
    }

    @Override
    public void process(EventObject eventObject) {
        ResponseEvent requestEvent = (ResponseEvent)eventObject;
        try {
            SIPResponse response = (SIPResponse)requestEvent.getResponse();
            int statusCode = response.getStatusCode();
            CallIdHeader callId = response.getCallId();
            String subscribeKey = GenericSubscribe.Helper.getKey("INVITE", callId.getCallId());
            if (statusCode == 100) {
                this.subscribe.getSipResponseSubscribe().getPublisher(subscribeKey).submit(response);
                return;
            }
            if (statusCode == 200) {
                Optional.ofNullable(this.subscribe.getSipResponseSubscribe().getPublisher(subscribeKey)).ifPresentOrElse(publisher -> publisher.submit(response), () -> log.warn("\u5bf9\u5e94\u8ba2\u9605 {} \u5df2\u7ed3\u675f", (Object)callId.getCallId()));
                ResponseEventExt event = (ResponseEventExt)requestEvent;
                String contentString = new String(response.getRawContent());
                GB28181DescriptionParser gb28181DescriptionParser = new GB28181DescriptionParser(contentString);
                GB28181Description sdp = gb28181DescriptionParser.parse();
                SipURI requestUri = SipFactory.getInstance().createAddressFactory().createSipURI(sdp.getOrigin().getUsername(), event.getRemoteIpAddress() + ":" + event.getRemotePort());
                Request reqAck = SipRequestBuilder.createAckRequest(response.getLocalAddress().getHostAddress(), requestUri, response);
                log.info("[\u56de\u590dack] {}-> {}:{} ", new Object[]{sdp.getOrigin().getUsername(), event.getRemoteIpAddress(), event.getRemotePort()});
                log.debug("{}", (Object)reqAck);
                this.sender.send(response.getLocalAddress().getHostAddress(), (Message)reqAck);
            }
        }
        catch (ParseException | SdpParseException | InvalidArgumentException | SipException e) {
            log.info("[\u70b9\u64ad\u56de\u590dACK]\uff0c\u5f02\u5e38\uff1a", e);
        }
    }

    public InviteResponseProcessor(SipListener sipListener, SipMessageSender sender, SipSubscribe subscribe) {
        this.sipListener = sipListener;
        this.sender = sender;
        this.subscribe = subscribe;
    }
}

