/*
 * Decompiled with CFR 0.152.
 */
package cn.skcks.docking.gb28181.core.sip.message.processor.register.request;

import cn.hutool.core.date.DateUtil;
import cn.skcks.docking.gb28181.config.sip.SipConfig;
import cn.skcks.docking.gb28181.core.sip.dto.RemoteInfo;
import cn.skcks.docking.gb28181.core.sip.dto.SipTransactionInfo;
import cn.skcks.docking.gb28181.core.sip.gb28181.sip.GbSipDate;
import cn.skcks.docking.gb28181.core.sip.listener.SipListener;
import cn.skcks.docking.gb28181.core.sip.message.processor.MessageProcessor;
import cn.skcks.docking.gb28181.core.sip.message.sender.SipMessageSender;
import cn.skcks.docking.gb28181.core.sip.utils.SipUtil;
import cn.skcks.docking.gb28181.orm.mybatis.dynamic.model.DockingDevice;
import cn.skcks.docking.gb28181.sdp.media.MediaStreamMode;
import cn.skcks.docking.gb28181.service.docking.device.DockingDeviceService;
import cn.skcks.docking.gb28181.sip.method.register.response.RegisterResponseBuilder;
import cn.skcks.docking.gb28181.sip.utils.DigestAuthenticationHelper;
import gov.nist.javax.sip.address.SipUri;
import gov.nist.javax.sip.header.Authorization;
import gov.nist.javax.sip.header.SIPDate;
import gov.nist.javax.sip.header.SIPDateHeader;
import gov.nist.javax.sip.message.SIPRequest;
import jakarta.annotation.PostConstruct;
import java.util.Calendar;
import java.util.EventObject;
import java.util.Locale;
import javax.sip.RequestEvent;
import javax.sip.address.Address;
import javax.sip.header.ExpiresHeader;
import javax.sip.header.FromHeader;
import javax.sip.header.Header;
import javax.sip.header.ViaHeader;
import javax.sip.message.Message;
import javax.sip.message.Request;
import javax.sip.message.Response;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.util.ObjectUtils;

@Component
public class RegisterRequestProcessor
implements MessageProcessor {
    private static final Logger log = LoggerFactory.getLogger(RegisterRequestProcessor.class);
    private final SipListener sipListener;
    private final SipMessageSender sender;
    private final SipConfig sipConfig;
    private final DockingDeviceService dockingDeviceService;

    @Override
    @PostConstruct
    public void init() {
        this.sipListener.addRequestProcessor("REGISTER", this);
    }

    @Override
    public void process(EventObject eventObject) {
        boolean authPass;
        RequestEvent requestEvent = (RequestEvent)eventObject;
        SIPRequest request = (SIPRequest)requestEvent.getRequest();
        FromHeader fromHeader = request.getFrom();
        Address address = fromHeader.getAddress();
        log.debug("From {}", (Object)address);
        SipUri uri = (SipUri)address.getURI();
        String deviceId = uri.getUser();
        log.debug("\u8bf7\u6c42\u6ce8\u518c \u8bbe\u5907id => {}", (Object)deviceId);
        DockingDevice device = this.dockingDeviceService.getDevice(deviceId);
        String senderIp = request.getLocalAddress().getHostAddress();
        RemoteInfo remoteInfo = SipUtil.getRemoteInfoFromRequest(request, false);
        log.debug("\u8fdc\u7a0b\u8fde\u63a5\u4fe1\u606f => {}", (Object)remoteInfo);
        if (device == null) {
            log.info("\u65b0\u6ce8\u518c\u7684\u8bbe\u5907 deviceId => {}", (Object)deviceId);
        } else if (this.dockingDeviceService.isOnline(deviceId) && this.dockingDeviceService.hasTransaction(deviceId)) {
            SipTransactionInfo transactionInfo = this.dockingDeviceService.getTransaction(deviceId);
            if (request.getCallIdHeader().getCallId().equals(transactionInfo.getCallId())) {
                log.info("\u8bbe\u5907\u6ce8\u518c\u7eed\u8ba2 deviceId => {}", (Object)deviceId);
                this.registerDevice(deviceId, device, request, senderIp, remoteInfo);
            }
        }
        RegisterResponseBuilder registerResponseBuilder = RegisterResponseBuilder.builder().build();
        String password = this.sipConfig.getPassword();
        Authorization authorization = request.getAuthorization();
        if (authorization == null && StringUtils.isNotBlank((CharSequence)password)) {
            Response response = registerResponseBuilder.createAuthorzatioinResponse((Request)request, this.sipConfig.getDomain(), password);
            this.sender.send(senderIp, (Message)response);
            return;
        }
        log.debug("\u8ba4\u8bc1\u4fe1\u606f => {}", (Object)authorization);
        boolean bl = authPass = StringUtils.isBlank((CharSequence)password) || DigestAuthenticationHelper.doAuthenticatePlainTextPassword((Request)request, (String)password);
        if (!authPass) {
            Response response = this.getMessageFactory().createResponse(403, (Request)request);
            response.setReasonPhrase("\u8ba4\u8bc1\u5931\u8d25");
            log.info("\u8bbe\u5907\u6ce8\u518c\u4fe1\u606f\u8ba4\u8bc1\u5931\u8d25 deviceId => {}", (Object)deviceId);
            this.sender.send(senderIp, (Message)response);
            return;
        }
        log.debug("\u8bbe\u5907 deviceId => {}, \u8ba4\u8bc1\u901a\u8fc7", (Object)deviceId);
        this.registerDevice(deviceId, device, request, senderIp, remoteInfo);
    }

    private Response generateRegisterResponse(Request request) {
        SIPRequest sipRequest = (SIPRequest)request;
        ExpiresHeader expires = sipRequest.getExpires();
        if (expires == null) {
            return this.getMessageFactory().createResponse(400, request);
        }
        Response response = this.getMessageFactory().createResponse(200, request);
        SIPDateHeader dateHeader = new SIPDateHeader();
        GbSipDate gbSipDate = new GbSipDate(Calendar.getInstance(Locale.ENGLISH).getTimeInMillis());
        dateHeader.setDate((SIPDate)gbSipDate);
        response.addHeader((Header)dateHeader);
        response.addHeader((Header)sipRequest.getContactHeader());
        response.addHeader((Header)expires);
        return response;
    }

    private void registerDevice(String deviceId, DockingDevice device, SIPRequest request, String senderIp, RemoteInfo remoteInfo) {
        Response response = this.generateRegisterResponse((Request)request);
        log.debug("response.getStatusCode {}", (Object)response.getStatusCode());
        if (response.getStatusCode() != 200) {
            this.sender.send(senderIp, (Message)response);
            return;
        }
        if (device == null) {
            device = new DockingDevice();
            device.setStreamMode(MediaStreamMode.UDP.getMode());
            device.setCharset("GB2312");
            device.setGeoCoordSys("WGS84");
            device.setDeviceId(deviceId);
            device.setOnLine(Boolean.valueOf(false));
        } else {
            if (ObjectUtils.isEmpty((Object)device.getStreamMode())) {
                device.setStreamMode(MediaStreamMode.UDP.getMode());
            }
            if (ObjectUtils.isEmpty((Object)device.getCharset())) {
                device.setCharset("GB2312");
            }
            if (ObjectUtils.isEmpty((Object)device.getGeoCoordSys())) {
                device.setGeoCoordSys("WGS84");
            }
        }
        device.setIp(remoteInfo.getIp());
        device.setPort(Integer.valueOf(remoteInfo.getPort()));
        device.setHostAddress(remoteInfo.getIp().concat(":").concat(String.valueOf(remoteInfo.getPort())));
        device.setLocalIp(senderIp);
        ViaHeader viaHeader = request.getTopmostViaHeader();
        String transport = viaHeader.getTransport();
        device.setTransport("TCP".equalsIgnoreCase(transport) ? "TCP" : "UDP");
        int expires = request.getExpires().getExpires();
        device.setExpires(Integer.valueOf(expires));
        if (expires == 0) {
            device.setOnLine(Boolean.valueOf(false));
            log.info("\u8bbe\u5907\u6ce8\u9500 deviceId => {}", (Object)deviceId);
            this.dockingDeviceService.offline(device);
        } else {
            device.setRegisterTime(DateUtil.now());
            this.dockingDeviceService.online(device, response);
        }
        this.sender.send(senderIp, (Message)response);
    }

    public RegisterRequestProcessor(SipListener sipListener, SipMessageSender sender, SipConfig sipConfig, DockingDeviceService dockingDeviceService) {
        this.sipListener = sipListener;
        this.sender = sender;
        this.sipConfig = sipConfig;
        this.dockingDeviceService = dockingDeviceService;
    }
}

