/*
 * Decompiled with CFR 0.152.
 */
package cn.skcks.docking.gb28181.core.sip.message.request;

import cn.skcks.docking.gb28181.common.redis.RedisUtil;
import cn.skcks.docking.gb28181.config.sip.SipConfig;
import cn.skcks.docking.gb28181.core.sip.dto.SipTransactionInfo;
import cn.skcks.docking.gb28181.core.sip.gb28181.cache.CacheUtil;
import cn.skcks.docking.gb28181.core.sip.message.MessageHelper;
import cn.skcks.docking.gb28181.core.sip.utils.SipUtil;
import cn.skcks.docking.gb28181.orm.mybatis.dynamic.model.DockingDevice;
import gov.nist.javax.sip.message.SIPRequest;
import gov.nist.javax.sip.message.SIPResponse;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.sip.InvalidArgumentException;
import javax.sip.PeerUnavailableException;
import javax.sip.SipException;
import javax.sip.SipFactory;
import javax.sip.address.Address;
import javax.sip.address.SipURI;
import javax.sip.address.URI;
import javax.sip.header.CSeqHeader;
import javax.sip.header.CallIdHeader;
import javax.sip.header.ContentTypeHeader;
import javax.sip.header.EventHeader;
import javax.sip.header.ExpiresHeader;
import javax.sip.header.FromHeader;
import javax.sip.header.Header;
import javax.sip.header.MaxForwardsHeader;
import javax.sip.header.SubjectHeader;
import javax.sip.header.ToHeader;
import javax.sip.header.ViaHeader;
import javax.sip.message.Request;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.annotation.DependsOn;
import org.springframework.stereotype.Component;

@DependsOn(value={"sipConfig"})
@Component
public class SipRequestBuilder
implements ApplicationContextAware {
    private static SipConfig sipConfig;

    private static SipFactory getSipFactory() {
        return SipFactory.getInstance();
    }

    private static SipURI getSipURI(String id, String address) {
        return MessageHelper.createSipURI(id, address);
    }

    private static Address getAddress(SipURI uri) {
        return MessageHelper.createAddress(uri);
    }

    private static FromHeader getFromHeader(Address fromAddress, String fromTag) {
        return MessageHelper.createFromHeader(fromAddress, fromTag);
    }

    private static ToHeader getToHeader(Address toAddress, String toTag) {
        return MessageHelper.createToHeader(toAddress, toTag);
    }

    private static MaxForwardsHeader getMaxForwardsHeader(int maxForwards) {
        return SipRequestBuilder.getSipFactory().createHeaderFactory().createMaxForwardsHeader(maxForwards);
    }

    private static List<ViaHeader> getDeviceViaHeaders(DockingDevice device, String viaTag) {
        ViaHeader viaHeader = SipRequestBuilder.getSipFactory().createHeaderFactory().createViaHeader(device.getLocalIp(), sipConfig.getPort().intValue(), device.getTransport(), viaTag);
        viaHeader.setRPort();
        return Collections.singletonList(viaHeader);
    }

    public static Request createMessageRequest(DockingDevice device, String content, String viaTag, String fromTag, String toTag, CallIdHeader callIdHeader) throws ParseException, InvalidArgumentException, PeerUnavailableException {
        Request request = null;
        SipURI requestURI = SipRequestBuilder.getSipURI(device.getDeviceId(), device.getHostAddress());
        List<ViaHeader> viaHeaders = SipRequestBuilder.getDeviceViaHeaders(device, viaTag);
        SipURI fromSipURI = SipRequestBuilder.getSipURI(sipConfig.getId(), sipConfig.getDomain());
        Address fromAddress = MessageHelper.createAddress(fromSipURI);
        FromHeader fromHeader = SipRequestBuilder.getFromHeader(fromAddress, fromTag);
        SipURI toSipURI = SipRequestBuilder.getSipURI(device.getDeviceId(), device.getHostAddress());
        Address toAddress = MessageHelper.createAddress(toSipURI);
        ToHeader toHeader = SipRequestBuilder.getToHeader(toAddress, toTag);
        MaxForwardsHeader maxForwards = SipRequestBuilder.getSipFactory().createHeaderFactory().createMaxForwardsHeader(70);
        CSeqHeader cSeqHeader = SipRequestBuilder.getSipFactory().createHeaderFactory().createCSeqHeader(SipRequestBuilder.getCSeq(), "MESSAGE");
        request = SipRequestBuilder.getSipFactory().createMessageFactory().createRequest((URI)requestURI, "MESSAGE", callIdHeader, cSeqHeader, fromHeader, toHeader, viaHeaders, maxForwards);
        request.addHeader((Header)SipUtil.createUserAgentHeader());
        ContentTypeHeader contentTypeHeader = SipRequestBuilder.getSipFactory().createHeaderFactory().createContentTypeHeader("Application", "MANSCDP+xml");
        request.setContent((Object)content, contentTypeHeader);
        return request;
    }

    public static Request createInviteRequest(DockingDevice device, String channelId, String content, String viaTag, String fromTag, String toTag, String ssrc, CallIdHeader callIdHeader) throws ParseException, InvalidArgumentException, PeerUnavailableException {
        Request request = null;
        SipURI requestLine = SipRequestBuilder.getSipURI(channelId, device.getHostAddress());
        List<ViaHeader> viaHeaders = SipRequestBuilder.getDeviceViaHeaders(device, viaTag);
        SipURI fromSipURI = SipRequestBuilder.getSipURI(sipConfig.getId(), sipConfig.getDomain());
        Address fromAddress = MessageHelper.createAddress(fromSipURI);
        FromHeader fromHeader = SipRequestBuilder.getFromHeader(fromAddress, fromTag);
        SipURI toSipURI = SipRequestBuilder.getSipURI(channelId, device.getHostAddress());
        Address toAddress = MessageHelper.createAddress(toSipURI);
        ToHeader toHeader = SipRequestBuilder.getToHeader(toAddress, null);
        MaxForwardsHeader maxForwards = SipRequestBuilder.getSipFactory().createHeaderFactory().createMaxForwardsHeader(70);
        CSeqHeader cSeqHeader = SipRequestBuilder.getSipFactory().createHeaderFactory().createCSeqHeader(SipRequestBuilder.getCSeq(), "INVITE");
        request = SipRequestBuilder.getSipFactory().createMessageFactory().createRequest((URI)requestLine, "INVITE", callIdHeader, cSeqHeader, fromHeader, toHeader, viaHeaders, maxForwards);
        request.addHeader((Header)SipUtil.createUserAgentHeader());
        Address concatAddress = MessageHelper.createAddress(SipRequestBuilder.getSipURI(sipConfig.getId(), device.getLocalIp() + ":" + sipConfig.getPort()));
        request.addHeader((Header)SipRequestBuilder.getSipFactory().createHeaderFactory().createContactHeader(concatAddress));
        SubjectHeader subjectHeader = SipRequestBuilder.getSipFactory().createHeaderFactory().createSubjectHeader(String.format("%s:%s,%s:%s", channelId, ssrc, sipConfig.getId(), 0));
        request.addHeader((Header)subjectHeader);
        ContentTypeHeader contentTypeHeader = SipRequestBuilder.getSipFactory().createHeaderFactory().createContentTypeHeader("APPLICATION", "SDP");
        request.setContent((Object)content, contentTypeHeader);
        return request;
    }

    public static Request createPlaybackInviteRequest(DockingDevice device, String channelId, String content, String viaTag, String fromTag, String toTag, CallIdHeader callIdHeader, String ssrc) throws ParseException, InvalidArgumentException, PeerUnavailableException {
        Request request = null;
        SipURI requestLine = SipRequestBuilder.getSipURI(channelId, device.getHostAddress());
        ArrayList<ViaHeader> viaHeaders = new ArrayList<ViaHeader>();
        ViaHeader viaHeader = SipRequestBuilder.getSipFactory().createHeaderFactory().createViaHeader(device.getLocalIp(), sipConfig.getPort().intValue(), device.getTransport(), viaTag);
        viaHeader.setRPort();
        viaHeaders.add(viaHeader);
        SipURI fromSipURI = SipRequestBuilder.getSipURI(sipConfig.getId(), sipConfig.getDomain());
        Address fromAddress = MessageHelper.createAddress(fromSipURI);
        FromHeader fromHeader = SipRequestBuilder.getFromHeader(fromAddress, fromTag);
        SipURI toSipURI = SipRequestBuilder.getSipURI(channelId, device.getHostAddress());
        Address toAddress = MessageHelper.createAddress(toSipURI);
        ToHeader toHeader = SipRequestBuilder.getToHeader(toAddress, null);
        MaxForwardsHeader maxForwards = SipRequestBuilder.getSipFactory().createHeaderFactory().createMaxForwardsHeader(70);
        CSeqHeader cSeqHeader = SipRequestBuilder.getSipFactory().createHeaderFactory().createCSeqHeader(SipRequestBuilder.getCSeq(), "INVITE");
        request = SipRequestBuilder.getSipFactory().createMessageFactory().createRequest((URI)requestLine, "INVITE", callIdHeader, cSeqHeader, fromHeader, toHeader, viaHeaders, maxForwards);
        Address concatAddress = MessageHelper.createAddress(SipRequestBuilder.getSipURI(sipConfig.getId(), device.getLocalIp() + ":" + sipConfig.getPort()));
        request.addHeader((Header)SipRequestBuilder.getSipFactory().createHeaderFactory().createContactHeader(concatAddress));
        request.addHeader((Header)SipUtil.createUserAgentHeader());
        SubjectHeader subjectHeader = SipRequestBuilder.getSipFactory().createHeaderFactory().createSubjectHeader(String.format("%s:%s,%s:%s", channelId, ssrc, sipConfig.getId(), 0));
        request.addHeader((Header)subjectHeader);
        ContentTypeHeader contentTypeHeader = SipRequestBuilder.getSipFactory().createHeaderFactory().createContentTypeHeader("APPLICATION", "SDP");
        request.setContent((Object)content, contentTypeHeader);
        return request;
    }

    public static Request createByeRequest(DockingDevice device, String channelId, SipTransactionInfo transactionInfo) throws ParseException, InvalidArgumentException, PeerUnavailableException {
        Request request = null;
        SipURI requestLine = SipRequestBuilder.getSipURI(channelId, device.getHostAddress());
        ArrayList<ViaHeader> viaHeaders = new ArrayList<ViaHeader>();
        ViaHeader viaHeader = SipRequestBuilder.getSipFactory().createHeaderFactory().createViaHeader(device.getLocalIp(), sipConfig.getPort().intValue(), device.getTransport(), SipUtil.generateViaTag());
        viaHeaders.add(viaHeader);
        SipURI fromSipURI = SipRequestBuilder.getSipURI(sipConfig.getId(), sipConfig.getDomain());
        Address fromAddress = MessageHelper.createAddress(fromSipURI);
        FromHeader fromHeader = SipRequestBuilder.getFromHeader(fromAddress, transactionInfo.getFromTag());
        SipURI toSipURI = SipRequestBuilder.getSipURI(channelId, device.getHostAddress());
        Address toAddress = MessageHelper.createAddress(toSipURI);
        ToHeader toHeader = SipRequestBuilder.getToHeader(toAddress, transactionInfo.getToTag());
        MaxForwardsHeader maxForwards = SipRequestBuilder.getSipFactory().createHeaderFactory().createMaxForwardsHeader(70);
        CSeqHeader cSeqHeader = SipRequestBuilder.getSipFactory().createHeaderFactory().createCSeqHeader(SipRequestBuilder.getCSeq(), "BYE");
        CallIdHeader callIdHeader = SipRequestBuilder.getSipFactory().createHeaderFactory().createCallIdHeader(transactionInfo.getCallId());
        request = SipRequestBuilder.getSipFactory().createMessageFactory().createRequest((URI)requestLine, "BYE", callIdHeader, cSeqHeader, fromHeader, toHeader, viaHeaders, maxForwards);
        request.addHeader((Header)SipUtil.createUserAgentHeader());
        Address concatAddress = MessageHelper.createAddress(SipRequestBuilder.getSipURI(sipConfig.getId(), device.getLocalIp() + ":" + sipConfig.getPort()));
        request.addHeader((Header)SipRequestBuilder.getSipFactory().createHeaderFactory().createContactHeader(concatAddress));
        request.addHeader((Header)SipUtil.createUserAgentHeader());
        return request;
    }

    public static Request createSubscribeRequest(DockingDevice device, String content, SIPRequest requestOld, Integer expires, String event, CallIdHeader callIdHeader) throws ParseException, InvalidArgumentException, PeerUnavailableException {
        Request request = null;
        SipURI requestURI = SipRequestBuilder.getSipURI(device.getDeviceId(), device.getHostAddress());
        ArrayList<ViaHeader> viaHeaders = new ArrayList<ViaHeader>();
        ViaHeader viaHeader = SipRequestBuilder.getSipFactory().createHeaderFactory().createViaHeader(device.getLocalIp(), sipConfig.getPort().intValue(), device.getTransport(), SipUtil.generateViaTag());
        viaHeader.setRPort();
        viaHeaders.add(viaHeader);
        SipURI fromSipURI = SipRequestBuilder.getSipURI(sipConfig.getId(), sipConfig.getDomain());
        Address fromAddress = MessageHelper.createAddress(fromSipURI);
        FromHeader fromHeader = SipRequestBuilder.getFromHeader(fromAddress, requestOld == null ? SipUtil.generateFromTag() : requestOld.getFromTag());
        SipURI toSipURI = SipRequestBuilder.getSipURI(device.getDeviceId(), device.getHostAddress());
        Address toAddress = MessageHelper.createAddress(toSipURI);
        ToHeader toHeader = SipRequestBuilder.getToHeader(toAddress, requestOld == null ? null : requestOld.getToTag());
        MaxForwardsHeader maxForwards = SipRequestBuilder.getSipFactory().createHeaderFactory().createMaxForwardsHeader(70);
        CSeqHeader cSeqHeader = SipRequestBuilder.getSipFactory().createHeaderFactory().createCSeqHeader(SipRequestBuilder.getCSeq(), "SUBSCRIBE");
        request = SipRequestBuilder.getSipFactory().createMessageFactory().createRequest((URI)requestURI, "SUBSCRIBE", callIdHeader, cSeqHeader, fromHeader, toHeader, viaHeaders, maxForwards);
        Address concatAddress = MessageHelper.createAddress(SipRequestBuilder.getSipURI(sipConfig.getId(), device.getLocalIp() + ":" + sipConfig.getPort()));
        request.addHeader((Header)SipRequestBuilder.getSipFactory().createHeaderFactory().createContactHeader(concatAddress));
        ExpiresHeader expireHeader = SipRequestBuilder.getSipFactory().createHeaderFactory().createExpiresHeader(expires.intValue());
        request.addHeader((Header)expireHeader);
        EventHeader eventHeader = SipRequestBuilder.getSipFactory().createHeaderFactory().createEventHeader(event);
        int random = (int)Math.floor(Math.random() * 10000.0);
        eventHeader.setEventId(String.valueOf(random));
        request.addHeader((Header)eventHeader);
        ContentTypeHeader contentTypeHeader = SipRequestBuilder.getSipFactory().createHeaderFactory().createContentTypeHeader("Application", "MANSCDP+xml");
        request.setContent((Object)content, contentTypeHeader);
        request.addHeader((Header)SipUtil.createUserAgentHeader());
        return request;
    }

    public static SIPRequest createInfoRequest(DockingDevice device, String channelId, String content, SipTransactionInfo transactionInfo) throws SipException, ParseException, InvalidArgumentException {
        if (device == null || transactionInfo == null) {
            return null;
        }
        SIPRequest request = null;
        SipURI requestLine = SipRequestBuilder.getSipURI(channelId, device.getHostAddress());
        ArrayList<ViaHeader> viaHeaders = new ArrayList<ViaHeader>();
        ViaHeader viaHeader = SipRequestBuilder.getSipFactory().createHeaderFactory().createViaHeader(device.getLocalIp(), sipConfig.getPort().intValue(), device.getTransport(), SipUtil.generateViaTag());
        viaHeaders.add(viaHeader);
        SipURI fromSipURI = SipRequestBuilder.getSipURI(sipConfig.getId(), sipConfig.getDomain());
        Address fromAddress = MessageHelper.createAddress(fromSipURI);
        FromHeader fromHeader = SipRequestBuilder.getFromHeader(fromAddress, transactionInfo.getFromTag());
        SipURI toSipURI = SipRequestBuilder.getSipURI(channelId, device.getHostAddress());
        Address toAddress = MessageHelper.createAddress(toSipURI);
        ToHeader toHeader = SipRequestBuilder.getToHeader(toAddress, transactionInfo.getToTag());
        MaxForwardsHeader maxForwards = SipRequestBuilder.getSipFactory().createHeaderFactory().createMaxForwardsHeader(70);
        CSeqHeader cSeqHeader = SipRequestBuilder.getSipFactory().createHeaderFactory().createCSeqHeader(SipRequestBuilder.getCSeq(), "INFO");
        CallIdHeader callIdHeader = SipRequestBuilder.getSipFactory().createHeaderFactory().createCallIdHeader(transactionInfo.getCallId());
        request = (SIPRequest)SipRequestBuilder.getSipFactory().createMessageFactory().createRequest((URI)requestLine, "INFO", callIdHeader, cSeqHeader, fromHeader, toHeader, viaHeaders, maxForwards);
        request.addHeader((Header)SipUtil.createUserAgentHeader());
        Address concatAddress = MessageHelper.createAddress(SipRequestBuilder.getSipURI(sipConfig.getId(), device.getLocalIp() + ":" + sipConfig.getPort()));
        request.addHeader((Header)SipRequestBuilder.getSipFactory().createHeaderFactory().createContactHeader(concatAddress));
        request.addHeader((Header)SipUtil.createUserAgentHeader());
        if (content != null) {
            ContentTypeHeader contentTypeHeader = SipRequestBuilder.getSipFactory().createHeaderFactory().createContentTypeHeader("Application", "MANSRTSP");
            request.setContent((Object)content, contentTypeHeader);
        }
        return request;
    }

    public static Request createAckRequest(String localIp, SipURI sipURI, SIPResponse sipResponse) throws ParseException, InvalidArgumentException, PeerUnavailableException {
        ArrayList<ViaHeader> viaHeaders = new ArrayList<ViaHeader>();
        ViaHeader viaHeader = SipRequestBuilder.getSipFactory().createHeaderFactory().createViaHeader(localIp, sipConfig.getPort().intValue(), sipResponse.getTopmostViaHeader().getTransport(), SipUtil.generateViaTag());
        viaHeaders.add(viaHeader);
        MaxForwardsHeader maxForwards = SipRequestBuilder.getSipFactory().createHeaderFactory().createMaxForwardsHeader(70);
        CSeqHeader cSeqHeader = SipRequestBuilder.getSipFactory().createHeaderFactory().createCSeqHeader(sipResponse.getCSeqHeader().getSeqNumber(), "ACK");
        Request request = SipRequestBuilder.getSipFactory().createMessageFactory().createRequest((URI)sipURI, "ACK", sipResponse.getCallIdHeader(), cSeqHeader, sipResponse.getFromHeader(), sipResponse.getToHeader(), viaHeaders, maxForwards);
        request.addHeader((Header)SipUtil.createUserAgentHeader());
        Address concatAddress = MessageHelper.createAddress(SipRequestBuilder.getSipURI(sipConfig.getId(), localIp + ":" + sipConfig.getPort()));
        request.addHeader((Header)SipRequestBuilder.getSipFactory().createHeaderFactory().createContactHeader(concatAddress));
        request.addHeader((Header)SipUtil.createUserAgentHeader());
        return request;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        sipConfig = (SipConfig)applicationContext.getBean(SipConfig.class);
    }

    public static long getCSeq() {
        String key = CacheUtil.getKey("SIP_C_SEQ", sipConfig.getId());
        long result = 1L;
        if (RedisUtil.KeyOps.hasKey((String)key)) {
            try {
                result = RedisUtil.StringOps.incrBy((String)key, (long)1L);
            }
            finally {
                if (result > Integer.MAX_VALUE) {
                    RedisUtil.StringOps.set((String)key, (String)String.valueOf(1L));
                    result = 1L;
                }
            }
        } else {
            RedisUtil.StringOps.set((String)key, (String)String.valueOf(result));
        }
        return result;
    }
}

