/*
 * Decompiled with CFR 0.152.
 */
package cn.skcks.docking.gb28181.core.sip.message.sender;

import cn.skcks.docking.gb28181.core.sip.service.SipService;
import cn.skcks.docking.gb28181.core.sip.utils.SipUtil;
import gov.nist.javax.sip.message.SIPMessage;
import java.text.ParseException;
import java.util.Optional;
import javax.sip.PeerUnavailableException;
import javax.sip.SipException;
import javax.sip.SipProvider;
import javax.sip.header.CallIdHeader;
import javax.sip.header.Header;
import javax.sip.header.ViaHeader;
import javax.sip.message.Message;
import javax.sip.message.Request;
import javax.sip.message.Response;
import org.apache.commons.lang3.ObjectUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class SipMessageSender {
    private static final Logger log = LoggerFactory.getLogger(SipMessageSender.class);
    private final SipService sipService;

    public void send(String ip, Message message) {
        String transport;
        SIPMessage sipMessage = (SIPMessage)message;
        ViaHeader viaHeader = sipMessage.getTopmostViaHeader();
        if (ObjectUtils.anyNull((Object[])new Object[]{viaHeader})) {
            transport = "UDP";
            log.warn("\u7f3a\u5c11\u4fe1\u606f\u5934 ViaHeader, \u9ed8\u8ba4\u4f7f\u7528 {} \u8fde\u63a5\u53d1\u9001\u4fe1\u606f", (Object)transport);
        } else {
            transport = viaHeader.getTransport();
        }
        log.debug("\u5c06\u4f7f\u7528 {} \u8fde\u63a5\u53d1\u9001\u6d88\u606f", (Object)transport);
        if (message.getHeader("User-Agent") == null) {
            try {
                message.addHeader((Header)SipUtil.createUserAgentHeader());
            }
            catch (ParseException | PeerUnavailableException e) {
                log.error("UserAgent \u6dfb\u52a0\u5931\u8d25");
            }
        }
        CallIdHeader callIdHeader = sipMessage.getCallIdHeader();
        SipProvider sipProvider = this.sipService.getProvider(transport, ip);
        Optional.ofNullable(sipProvider).ifPresentOrElse(provider -> {
            try {
                if (message instanceof Request) {
                    provider.sendRequest((Request)message);
                } else if (message instanceof Response) {
                    provider.sendResponse((Response)message);
                }
            }
            catch (SipException e) {
                log.error("\u6d88\u606f\u53d1\u9001\u5931\u8d25");
            }
        }, () -> log.error("\u672a\u80fd\u627e\u5230 {}://{} \u76d1\u542c\u4fe1\u606f", (Object)transport, (Object)ip));
    }

    public SipMessageSender(SipService sipService) {
        this.sipService = sipService;
    }
}

