/*
 * Decompiled with CFR 0.152.
 */
package cn.skcks.docking.gb28181.core.sip.message.subscribe;

import java.util.Map;
import java.util.Optional;
import java.util.concurrent.Executor;
import java.util.concurrent.Flow;
import java.util.concurrent.SubmissionPublisher;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;

public interface GenericSubscribe<T> {
    public void close();

    public void addPublisher(String var1);

    public SubmissionPublisher<T> getPublisher(String var1);

    public void addSubscribe(String var1, Flow.Subscriber<T> var2);

    public void delPublisher(String var1);

    public void complete(String var1);

    public static class Helper {
        public static final String SEPARATOR = ":";

        public static String getKey(String prefix, String ... ids) {
            return StringUtils.joinWith((String)SEPARATOR, (Object[])ArrayUtils.addFirst((Object[])ids, (Object)prefix));
        }

        public static <T> void close(Map<String, SubmissionPublisher<T>> publishers) {
            publishers.values().forEach(SubmissionPublisher::close);
            publishers.clear();
        }

        public static <T> void delPublisher(Map<String, SubmissionPublisher<T>> publishers, String key) {
            SubmissionPublisher<T> publisher = publishers.remove(key);
            Optional.ofNullable(publisher).ifPresent(SubmissionPublisher::close);
        }

        public static <T> void addPublisher(Executor executor, Map<String, SubmissionPublisher<T>> publishers, String key) {
            SubmissionPublisher publisher = new SubmissionPublisher(executor, Flow.defaultBufferSize());
            publishers.put(key, publisher);
        }

        public static <T> void addPublisher(Executor executor, Map<String, SubmissionPublisher<T>> publishers, String key, int bufferSize) {
            SubmissionPublisher publisher = new SubmissionPublisher(executor, bufferSize);
            publishers.put(key, publisher);
        }

        public static <T> SubmissionPublisher<T> getPublisher(Map<String, SubmissionPublisher<T>> publishers, String key) {
            return publishers.get(key);
        }

        public static <T> void addSubscribe(Map<String, SubmissionPublisher<T>> publishers, String key, Flow.Subscriber<T> subscribe) {
            SubmissionPublisher<T> publisher = Helper.getPublisher(publishers, key);
            if (publisher != null) {
                publisher.subscribe(subscribe);
            }
        }
    }
}

