/*
 * Decompiled with CFR 0.152.
 */
package cn.skcks.docking.gb28181.core.sip.message.subscribe;

import cn.skcks.docking.gb28181.core.sip.message.subscribe.GenericSubscribe;
import cn.skcks.docking.gb28181.core.sip.message.subscribe.GenericTimeoutSubscribe;
import gov.nist.javax.sip.message.SIPRequest;
import java.io.Closeable;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Executor;
import java.util.concurrent.Flow;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.SubmissionPublisher;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SipRequestSubscribe
implements GenericTimeoutSubscribe<SIPRequest>,
Closeable {
    private static final Logger log = LoggerFactory.getLogger(SipRequestSubscribe.class);
    private final Executor executor;
    private final ScheduledExecutorService scheduledExecutorService;
    private final ConcurrentMap<String, ScheduledFuture<?>> scheduledFutureManager = new ConcurrentHashMap(0);
    private static final Map<String, SubmissionPublisher<SIPRequest>> publishers = new ConcurrentHashMap<String, SubmissionPublisher<SIPRequest>>();

    @Override
    public void close() {
        GenericSubscribe.Helper.close(publishers);
    }

    @Override
    public void addPublisher(String key) {
        GenericSubscribe.Helper.addPublisher(this.executor, publishers, key);
    }

    @Override
    public SubmissionPublisher<SIPRequest> getPublisher(String key) {
        return GenericSubscribe.Helper.getPublisher(publishers, key);
    }

    @Override
    public void addSubscribe(String key, Flow.Subscriber<SIPRequest> subscribe) {
        GenericSubscribe.Helper.addSubscribe(publishers, key, subscribe);
    }

    @Override
    public void complete(String key) {
        this.delPublisher(key);
    }

    @Override
    public void delPublisher(String key) {
        ScheduledFuture schedule = (ScheduledFuture)this.scheduledFutureManager.remove(key);
        Optional.ofNullable(schedule).ifPresent(scheduledFuture -> scheduledFuture.cancel(true));
        GenericSubscribe.Helper.delPublisher(publishers, key);
    }

    @Override
    public void addPublisher(String key, long time, TimeUnit timeUnit) {
        this.addPublisher(key);
        ScheduledFuture<?> schedule = this.scheduledExecutorService.schedule(() -> {
            this.scheduledFutureManager.remove(key);
            this.delPublisher(key);
            log.debug("\u6e05\u7406\u8d85\u65f6 \u8bf7\u6c42 \u8ba2\u9605\u5668 {}", (Object)key);
        }, time, timeUnit);
        this.scheduledFutureManager.put(key, schedule);
    }

    @Override
    public void refreshPublisher(String key, long time, TimeUnit timeUnit) {
        ScheduledFuture<?> schedule = (ScheduledFuture<?>)this.scheduledFutureManager.remove(key);
        Optional.ofNullable(schedule).ifPresent(scheduledFuture -> scheduledFuture.cancel(true));
        schedule = this.scheduledExecutorService.schedule(() -> {
            this.scheduledFutureManager.remove(key);
            this.delPublisher(key);
            log.debug("\u6e05\u7406\u8d85\u65f6 \u8bf7\u6c42 \u8ba2\u9605\u5668 {}", (Object)key);
        }, time, timeUnit);
        this.scheduledFutureManager.put(key, schedule);
    }

    public SipRequestSubscribe(Executor executor, ScheduledExecutorService scheduledExecutorService) {
        this.executor = executor;
        this.scheduledExecutorService = scheduledExecutorService;
    }
}

