/*
 * Decompiled with CFR 0.152.
 */
package cn.skcks.docking.gb28181.core.sip.message.subscribe;

import cn.skcks.docking.gb28181.core.sip.message.subscribe.GenericTimeoutSubscribe;
import cn.skcks.docking.gb28181.core.sip.message.subscribe.SipRequestSubscribe;
import cn.skcks.docking.gb28181.core.sip.message.subscribe.SipResponseSubscribe;
import gov.nist.javax.sip.message.SIPRequest;
import gov.nist.javax.sip.message.SIPResponse;
import jakarta.annotation.PostConstruct;
import jakarta.annotation.PreDestroy;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;

@Service
public class SipSubscribe {
    private static final Logger log = LoggerFactory.getLogger(SipSubscribe.class);
    @Qualifier(value="sipTaskExecutor")
    private final Executor executor;
    private final ScheduledExecutorService scheduledExecutorService = Executors.newScheduledThreadPool(Runtime.getRuntime().availableProcessors());
    private GenericTimeoutSubscribe<SIPResponse> sipResponseSubscribe;
    private GenericTimeoutSubscribe<SIPRequest> sipRequestSubscribe;

    @PostConstruct
    private void init() {
        this.sipResponseSubscribe = new SipResponseSubscribe(this.executor, this.scheduledExecutorService);
        this.sipRequestSubscribe = new SipRequestSubscribe(this.executor, this.scheduledExecutorService);
    }

    @PreDestroy
    private void destroy() {
        this.sipResponseSubscribe.close();
        this.sipRequestSubscribe.close();
    }

    @Qualifier(value="sipTaskExecutor")
    public Executor getExecutor() {
        return this.executor;
    }

    public ScheduledExecutorService getScheduledExecutorService() {
        return this.scheduledExecutorService;
    }

    public GenericTimeoutSubscribe<SIPResponse> getSipResponseSubscribe() {
        return this.sipResponseSubscribe;
    }

    public GenericTimeoutSubscribe<SIPRequest> getSipRequestSubscribe() {
        return this.sipRequestSubscribe;
    }

    public void setSipResponseSubscribe(GenericTimeoutSubscribe<SIPResponse> sipResponseSubscribe) {
        this.sipResponseSubscribe = sipResponseSubscribe;
    }

    public void setSipRequestSubscribe(GenericTimeoutSubscribe<SIPRequest> sipRequestSubscribe) {
        this.sipRequestSubscribe = sipRequestSubscribe;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SipSubscribe)) {
            return false;
        }
        SipSubscribe other = (SipSubscribe)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Executor this$executor = this.getExecutor();
        Executor other$executor = other.getExecutor();
        if (this$executor == null ? other$executor != null : !this$executor.equals(other$executor)) {
            return false;
        }
        ScheduledExecutorService this$scheduledExecutorService = this.getScheduledExecutorService();
        ScheduledExecutorService other$scheduledExecutorService = other.getScheduledExecutorService();
        if (this$scheduledExecutorService == null ? other$scheduledExecutorService != null : !this$scheduledExecutorService.equals(other$scheduledExecutorService)) {
            return false;
        }
        GenericTimeoutSubscribe<SIPResponse> this$sipResponseSubscribe = this.getSipResponseSubscribe();
        GenericTimeoutSubscribe<SIPResponse> other$sipResponseSubscribe = other.getSipResponseSubscribe();
        if (this$sipResponseSubscribe == null ? other$sipResponseSubscribe != null : !this$sipResponseSubscribe.equals(other$sipResponseSubscribe)) {
            return false;
        }
        GenericTimeoutSubscribe<SIPRequest> this$sipRequestSubscribe = this.getSipRequestSubscribe();
        GenericTimeoutSubscribe<SIPRequest> other$sipRequestSubscribe = other.getSipRequestSubscribe();
        return !(this$sipRequestSubscribe == null ? other$sipRequestSubscribe != null : !this$sipRequestSubscribe.equals(other$sipRequestSubscribe));
    }

    protected boolean canEqual(Object other) {
        return other instanceof SipSubscribe;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Executor $executor = this.getExecutor();
        result = result * 59 + ($executor == null ? 43 : $executor.hashCode());
        ScheduledExecutorService $scheduledExecutorService = this.getScheduledExecutorService();
        result = result * 59 + ($scheduledExecutorService == null ? 43 : $scheduledExecutorService.hashCode());
        GenericTimeoutSubscribe<SIPResponse> $sipResponseSubscribe = this.getSipResponseSubscribe();
        result = result * 59 + ($sipResponseSubscribe == null ? 43 : $sipResponseSubscribe.hashCode());
        GenericTimeoutSubscribe<SIPRequest> $sipRequestSubscribe = this.getSipRequestSubscribe();
        result = result * 59 + ($sipRequestSubscribe == null ? 43 : $sipRequestSubscribe.hashCode());
        return result;
    }

    public String toString() {
        return "SipSubscribe(executor=" + this.getExecutor() + ", scheduledExecutorService=" + this.getScheduledExecutorService() + ", sipResponseSubscribe=" + this.getSipResponseSubscribe() + ", sipRequestSubscribe=" + this.getSipRequestSubscribe() + ")";
    }

    public SipSubscribe(@Qualifier(value="sipTaskExecutor") Executor executor) {
        this.executor = executor;
    }
}

