/*
 * Decompiled with CFR 0.152.
 */
package cn.skcks.docking.gb28181.core.sip.service;

import cn.skcks.docking.gb28181.config.sip.SipConfig;
import cn.skcks.docking.gb28181.core.sip.message.parser.GbStringMsgParserFactory;
import cn.skcks.docking.gb28181.core.sip.properties.DefaultProperties;
import cn.skcks.docking.gb28181.core.sip.service.SipService;
import gov.nist.javax.sip.SipProviderImpl;
import gov.nist.javax.sip.SipStackImpl;
import gov.nist.javax.sip.parser.MessageParserFactory;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.sip.InvalidArgumentException;
import javax.sip.ListeningPoint;
import javax.sip.ObjectInUseException;
import javax.sip.SipException;
import javax.sip.SipFactory;
import javax.sip.SipListener;
import javax.sip.SipProvider;
import javax.sip.TransportNotSupportedException;
import javax.sip.message.Request;
import javax.sip.message.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Service;

@Order(value=10)
@Service
public class SipServiceImpl
implements SipService {
    private static final Logger log = LoggerFactory.getLogger(SipServiceImpl.class);
    private final SipFactory sipFactory = SipFactory.getInstance();
    private final SipConfig sipConfig;
    private final cn.skcks.docking.gb28181.core.sip.listener.SipListener sipListener;
    private final List<SipProviderImpl> pool = new ArrayList<SipProviderImpl>(2);
    private SipStackImpl sipStack;

    @Override
    public void run() {
        this.sipFactory.setPathName("gov.nist");
        this.sipConfig.getIp().parallelStream().forEach(ip -> this.listen((String)ip, this.sipConfig.getPort()));
    }

    @Override
    public void stop() {
        if (this.sipStack == null) {
            return;
        }
        this.sipStack.closeAllSockets();
        this.pool.parallelStream().forEach(sipProvider -> {
            ListeningPoint listen = sipProvider.getListeningPoint();
            log.debug("\u79fb\u9664\u76d1\u542c {}://{}:{}", new Object[]{listen.getTransport(), listen.getIPAddress(), listen.getPort()});
            sipProvider.removeSipListener((SipListener)this.sipListener);
            sipProvider.removeListeningPoints();
            try {
                this.sipStack.deleteListeningPoint(listen);
                this.sipStack.deleteSipProvider((SipProvider)sipProvider);
            }
            catch (Exception exception) {
                // empty catch block
            }
        });
        this.pool.clear();
    }

    @Override
    public SipProvider getProvider(String transport, String ip) {
        return this.pool.parallelStream().filter(sipProvider -> {
            ListeningPoint listeningPoint = sipProvider.getListeningPoint();
            return listeningPoint != null && listeningPoint.getIPAddress().equals(ip) && listeningPoint.getTransport().equalsIgnoreCase(transport);
        }).findFirst().orElse(null);
    }

    public List<SipProvider> getProviders(String transport) {
        return this.sipConfig.getIp().stream().map(item -> this.getProvider(transport, (String)item)).filter(Objects::nonNull).toList();
    }

    public void sendResponse(SipProvider sipProvider, SendResponse response) {
        log.info("{}", (Object)sipProvider);
        ListeningPoint[] listeningPoints = sipProvider.getListeningPoints();
        if (listeningPoints == null || listeningPoints.length == 0) {
            log.error("\u53d1\u9001\u54cd\u5e94\u5931\u8d25, \u672a\u627e\u5230\u6709\u6548\u7684\u76d1\u542c\u5730\u5740");
            return;
        }
        ListeningPoint listeningPoint = listeningPoints[0];
        String ip = listeningPoint.getIPAddress();
        int port = listeningPoint.getPort();
        try {
            sipProvider.sendResponse(response.build(sipProvider, ip, port));
        }
        catch (SipException e) {
            log.error("\u5411{} {}:{} \u53d1\u9001\u54cd\u5e94\u5931\u8d25, \u5f02\u5e38: {}", new Object[]{ip, listeningPoint.getPort(), listeningPoint.getTransport(), e.getMessage()});
        }
    }

    public void sendResponse(String senderIp, String transport, SendResponse response) {
        SipProvider sipProvider = this.getProvider(transport, senderIp);
        this.sendResponse(sipProvider, response);
    }

    public void sendRequest(String transport, SendRequest request) {
        this.getProviders(transport).parallelStream().forEach(sipProvider -> {
            log.info("{}", sipProvider);
            ListeningPoint[] listeningPoints = sipProvider.getListeningPoints();
            if (listeningPoints == null || listeningPoints.length == 0) {
                log.error("\u53d1\u9001\u8bf7\u6c42\u5931\u8d25, \u672a\u627e\u5230\u6709\u6548\u7684\u76d1\u542c\u5730\u5740");
                return;
            }
            ListeningPoint listeningPoint = listeningPoints[0];
            String ip = listeningPoint.getIPAddress();
            int port = listeningPoint.getPort();
            try {
                sipProvider.sendRequest(request.build((SipProvider)sipProvider, ip, port));
            }
            catch (SipException e) {
                log.error("\u5411{} {}:{} \u53d1\u9001\u8bf7\u6c42\u5931\u8d25, \u5f02\u5e38: {}", new Object[]{ip, listeningPoint.getPort(), listeningPoint.getTransport(), e.getMessage()});
            }
        });
    }

    public void listen(String ip, int port) {
        try {
            this.sipStack = (SipStackImpl)this.sipFactory.createSipStack(DefaultProperties.getProperties("GB28181_SIP"));
            this.sipStack.setMessageParserFactory((MessageParserFactory)new GbStringMsgParserFactory());
            try {
                ListeningPoint tcpListen = this.sipStack.createListeningPoint(ip, port, "TCP");
                SipProviderImpl tcpSipProvider = (SipProviderImpl)this.sipStack.createSipProvider(tcpListen);
                tcpSipProvider.setDialogErrorsAutomaticallyHandled();
                tcpSipProvider.addSipListener((SipListener)this.sipListener);
                this.pool.add(tcpSipProvider);
                log.info("[sip] \u76d1\u542c tcp://{}:{}", (Object)ip, (Object)port);
            }
            catch (InvalidArgumentException | ObjectInUseException | TransportNotSupportedException e) {
                log.error("[sip] tcp://{}:{} \u76d1\u542c\u5931\u8d25, \u8bf7\u68c0\u67e5\u7aef\u53e3\u662f\u5426\u88ab\u5360\u7528, \u9519\u8bef\u4fe1\u606f => {}", new Object[]{ip, port, e.getMessage()});
            }
            try {
                ListeningPoint udpListen = this.sipStack.createListeningPoint(ip, port, "UDP");
                SipProviderImpl udpSipProvider = (SipProviderImpl)this.sipStack.createSipProvider(udpListen);
                udpSipProvider.addSipListener((SipListener)this.sipListener);
                this.pool.add(udpSipProvider);
                log.info("[sip] \u76d1\u542c udp://{}:{}", (Object)ip, (Object)port);
            }
            catch (InvalidArgumentException | ObjectInUseException | TransportNotSupportedException e) {
                log.error("[sip] udp://{}:{} \u76d1\u542c\u5931\u8d25, \u8bf7\u68c0\u67e5\u7aef\u53e3\u662f\u5426\u88ab\u5360\u7528, \u9519\u8bef\u4fe1\u606f => {}", new Object[]{ip, port, e.getMessage()});
            }
        }
        catch (Exception e) {
            log.error("[sip] {}:{} \u76d1\u542c\u5931\u8d25, \u8bf7\u68c0\u67e5\u7aef\u53e3\u662f\u5426\u88ab\u5360\u7528, \u9519\u8bef\u4fe1\u606f => {}", new Object[]{ip, port, e.getMessage()});
            Runtime.getRuntime().exit(-1);
        }
    }

    public SipServiceImpl(SipConfig sipConfig, cn.skcks.docking.gb28181.core.sip.listener.SipListener sipListener) {
        this.sipConfig = sipConfig;
        this.sipListener = sipListener;
    }

    public SipFactory getSipFactory() {
        return this.sipFactory;
    }

    public SipConfig getSipConfig() {
        return this.sipConfig;
    }

    public cn.skcks.docking.gb28181.core.sip.listener.SipListener getSipListener() {
        return this.sipListener;
    }

    public List<SipProviderImpl> getPool() {
        return this.pool;
    }

    public SipStackImpl getSipStack() {
        return this.sipStack;
    }

    public void setSipStack(SipStackImpl sipStack) {
        this.sipStack = sipStack;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SipServiceImpl)) {
            return false;
        }
        SipServiceImpl other = (SipServiceImpl)o;
        if (!other.canEqual(this)) {
            return false;
        }
        SipFactory this$sipFactory = this.getSipFactory();
        SipFactory other$sipFactory = other.getSipFactory();
        if (this$sipFactory == null ? other$sipFactory != null : !this$sipFactory.equals(other$sipFactory)) {
            return false;
        }
        SipConfig this$sipConfig = this.getSipConfig();
        SipConfig other$sipConfig = other.getSipConfig();
        if (this$sipConfig == null ? other$sipConfig != null : !((Object)this$sipConfig).equals(other$sipConfig)) {
            return false;
        }
        cn.skcks.docking.gb28181.core.sip.listener.SipListener this$sipListener = this.getSipListener();
        cn.skcks.docking.gb28181.core.sip.listener.SipListener other$sipListener = other.getSipListener();
        if (this$sipListener == null ? other$sipListener != null : !this$sipListener.equals(other$sipListener)) {
            return false;
        }
        List<SipProviderImpl> this$pool = this.getPool();
        List<SipProviderImpl> other$pool = other.getPool();
        if (this$pool == null ? other$pool != null : !((Object)this$pool).equals(other$pool)) {
            return false;
        }
        SipStackImpl this$sipStack = this.getSipStack();
        SipStackImpl other$sipStack = other.getSipStack();
        return !(this$sipStack == null ? other$sipStack != null : !this$sipStack.equals(other$sipStack));
    }

    protected boolean canEqual(Object other) {
        return other instanceof SipServiceImpl;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        SipFactory $sipFactory = this.getSipFactory();
        result = result * 59 + ($sipFactory == null ? 43 : $sipFactory.hashCode());
        SipConfig $sipConfig = this.getSipConfig();
        result = result * 59 + ($sipConfig == null ? 43 : ((Object)$sipConfig).hashCode());
        cn.skcks.docking.gb28181.core.sip.listener.SipListener $sipListener = this.getSipListener();
        result = result * 59 + ($sipListener == null ? 43 : $sipListener.hashCode());
        List<SipProviderImpl> $pool = this.getPool();
        result = result * 59 + ($pool == null ? 43 : ((Object)$pool).hashCode());
        SipStackImpl $sipStack = this.getSipStack();
        result = result * 59 + ($sipStack == null ? 43 : $sipStack.hashCode());
        return result;
    }

    public String toString() {
        return "SipServiceImpl(sipFactory=" + this.getSipFactory() + ", sipConfig=" + this.getSipConfig() + ", sipListener=" + this.getSipListener() + ", pool=" + this.getPool() + ", sipStack=" + this.getSipStack() + ")";
    }

    public static interface SendResponse {
        public Response build(SipProvider var1, String var2, int var3);
    }

    public static interface SendRequest {
        public Request build(SipProvider var1, String var2, int var3);
    }
}

